/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.binding;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.binding.Initializer;
import org.jruby.javasupport.binding.MethodGatherer;

final class ClassInitializer
extends Initializer {
    ClassInitializer(Ruby runtime2, Class<?> javaClass) {
        super(runtime2, javaClass);
    }

    @Override
    public RubyClass initialize(RubyModule proxy2) {
        RubyClass proxyClass = (RubyClass)proxy2;
        proxy2.setJavaProxy(true);
        proxy2.getSingletonClass().setJavaProxy(true);
        Class<?> enclosingClass = this.javaClass.getEnclosingClass();
        RubyModule parent = enclosingClass != null ? Java.getProxyClass(this.runtime, enclosingClass) : Java.getJavaPackageModule(this.runtime, this.javaClass.getPackage());
        proxy2.setParent(parent);
        if (this.javaClass.isMemberClass()) {
            proxy2.setBaseName(this.javaClass.getSimpleName());
        } else {
            String baseName = this.javaClass.getSimpleName();
            if (enclosingClass != null) {
                int offset2;
                String className = this.javaClass.getName();
                int length2 = className.length();
                if (length2 > (offset2 = enclosingClass.getName().length()) && className.charAt(offset2) != '$') {
                    baseName = className.substring(offset2);
                } else if (length2 > offset2 + 1) {
                    baseName = className.substring(offset2 + 1);
                }
            }
            proxy2.setBaseName(baseName);
        }
        proxyClass.getName();
        MethodGatherer state2 = new MethodGatherer(this.runtime, this.javaClass.getSuperclass());
        state2.initialize(this.javaClass, proxy2);
        return proxyClass;
    }
}

