/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import java.util.ArrayList;
import org.jruby.runtime.ThreadContext;

final class Invocation {
    private final ThreadContext context;
    private final int postInvokeCount;
    private final int referenceCount;
    private ArrayList<Runnable> postInvokeList;
    private ArrayList<Object> references;

    public Invocation(ThreadContext context) {
        this(context, 0, 0);
    }

    Invocation(ThreadContext context, int postInvokeCount, int referenceCount) {
        this.context = context;
        this.postInvokeCount = postInvokeCount;
        this.referenceCount = referenceCount;
    }

    void finish() {
        if (this.postInvokeList != null) {
            for (Runnable r : this.postInvokeList) {
                r.run();
            }
        }
    }

    void addPostInvoke(Runnable postInvoke) {
        if (this.postInvokeList == null) {
            this.postInvokeList = new ArrayList(this.postInvokeCount);
        }
        this.postInvokeList.add(postInvoke);
    }

    ThreadContext getThreadContext() {
        return this.context;
    }

    void addReference(Object ref) {
        if (this.references == null) {
            this.references = new ArrayList(this.referenceCount);
        }
        this.references.add(ref);
    }
}

