/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat.internal;

import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.cache.spi.Region;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.stat.CacheableDataStatistics;

public abstract class AbstractCacheableDataStatistics
implements CacheableDataStatistics {
    private final @Nullable @UnknownKeyFor @Initialized String cacheRegionName;
    private final @Nullable @UnknownKeyFor @Initialized LongAdder cacheHitCount;
    private final @Nullable @UnknownKeyFor @Initialized LongAdder cacheMissCount;
    private final @Nullable @UnknownKeyFor @Initialized LongAdder cachePutCount;

    public AbstractCacheableDataStatistics(@UnknownKeyFor @NonNull @Initialized Supplier<@Nullable @UnknownKeyFor @Initialized Region> regionSupplier) {
        Region region = regionSupplier.get();
        if (region == null) {
            this.cacheRegionName = null;
            this.cacheHitCount = null;
            this.cacheMissCount = null;
            this.cachePutCount = null;
        } else {
            this.cacheRegionName = region.getName();
            this.cacheHitCount = new LongAdder();
            this.cacheMissCount = new LongAdder();
            this.cachePutCount = new LongAdder();
        }
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized String getCacheRegionName() {
        return this.cacheRegionName;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getCacheHitCount() {
        if (this.cacheRegionName == null) {
            return Long.MIN_VALUE;
        }
        return NullnessUtil.castNonNull(this.cacheHitCount).sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getCachePutCount() {
        if (this.cacheRegionName == null) {
            return Long.MIN_VALUE;
        }
        return NullnessUtil.castNonNull(this.cachePutCount).sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getCacheMissCount() {
        if (this.cacheRegionName == null) {
            return Long.MIN_VALUE;
        }
        return NullnessUtil.castNonNull(this.cacheMissCount).sum();
    }

    public void incrementCacheHitCount() {
        if (this.cacheRegionName == null) {
            throw new IllegalStateException("Illegal attempt to increment cache hit count for non-cached data");
        }
        NullnessUtil.castNonNull(this.cacheHitCount).increment();
    }

    public void incrementCacheMissCount() {
        if (this.cacheRegionName == null) {
            throw new IllegalStateException("Illegal attempt to increment cache miss count for non-cached data");
        }
        NullnessUtil.castNonNull(this.cacheMissCount).increment();
    }

    public void incrementCachePutCount() {
        if (this.cacheRegionName == null) {
            throw new IllegalStateException("Illegal attempt to increment cache put count for non-cached data");
        }
        NullnessUtil.castNonNull(this.cachePutCount).increment();
    }

    protected void appendCacheStats(@UnknownKeyFor @NonNull @Initialized StringBuilder buf) {
        buf.append(",cacheRegion=").append(this.cacheRegionName);
        if (this.cacheRegionName == null) {
            return;
        }
        buf.append(",cacheHitCount=").append(this.getCacheHitCount()).append(",cacheMissCount=").append(this.getCacheMissCount()).append(",cachePutCount=").append(this.getCachePutCount());
    }
}

