/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import java.sql.CallableStatement;
import java.sql.SQLException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.OutputableType;
import org.hibernate.sql.exec.spi.JdbcCallParameterExtractor;

public class JdbcCallParameterExtractorImpl<T>
implements JdbcCallParameterExtractor<T> {
    private final String callableName;
    private final String parameterName;
    private final int parameterPosition;
    private final OutputableType<T> ormType;

    public JdbcCallParameterExtractorImpl(String callableName, String parameterName, int parameterPosition, OutputableType<T> ormType) {
        this.callableName = callableName;
        this.parameterName = parameterName;
        this.parameterPosition = parameterPosition;
        this.ormType = ormType;
    }

    @Override
    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    public int getParameterPosition() {
        return this.parameterPosition;
    }

    @Override
    public T extractValue(CallableStatement callableStatement, boolean shouldUseJdbcNamedParameters, SharedSessionContractImplementor session) {
        boolean useNamed = shouldUseJdbcNamedParameters && this.parameterName != null;
        try {
            if (useNamed) {
                return this.ormType.extract(callableStatement, this.parameterName, session);
            }
            return this.ormType.extract(callableStatement, this.parameterPosition, session);
        }
        catch (SQLException e) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(e, "Unable to extract OUT/INOUT parameter value");
        }
    }
}

