/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import jakarta.persistence.AccessType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.internal.AccessStrategyHelper;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.GetterFieldImpl;
import org.hibernate.property.access.spi.GetterMethodImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessBuildingException;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.property.access.spi.SetterFieldImpl;
import org.hibernate.property.access.spi.SetterMethodImpl;

public class PropertyAccessMixedImpl
implements PropertyAccess {
    private final @UnknownKeyFor @NonNull @Initialized PropertyAccessStrategy strategy;
    private final @UnknownKeyFor @NonNull @Initialized Getter getter;
    private final @UnknownKeyFor @NonNull @Initialized Setter setter;

    public PropertyAccessMixedImpl(@UnknownKeyFor @NonNull @Initialized PropertyAccessStrategy strategy, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerJavaType, @UnknownKeyFor @NonNull @Initialized String propertyName) {
        this.strategy = strategy;
        AccessType propertyAccessType = AccessStrategyHelper.getAccessType(containerJavaType, propertyName);
        switch (propertyAccessType) {
            case FIELD: {
                Field field = AccessStrategyHelper.fieldOrNull(containerJavaType, propertyName);
                if (field == null) {
                    throw new PropertyAccessBuildingException("Could not locate field for property named [" + containerJavaType.getName() + "#" + propertyName + "]");
                }
                this.getter = PropertyAccessMixedImpl.fieldGetter(containerJavaType, propertyName, field);
                this.setter = PropertyAccessMixedImpl.fieldSetter(containerJavaType, propertyName, field);
                break;
            }
            case PROPERTY: {
                Method getterMethod = ReflectHelper.getterMethodOrNull(containerJavaType, propertyName);
                if (getterMethod == null) {
                    throw new PropertyAccessBuildingException("Could not locate getter for property named [" + containerJavaType.getName() + "#" + propertyName + "]");
                }
                Method setterMethod = ReflectHelper.findSetterMethod(containerJavaType, propertyName, getterMethod.getReturnType());
                this.getter = PropertyAccessMixedImpl.propertyGetter(containerJavaType, propertyName, getterMethod);
                this.setter = PropertyAccessMixedImpl.propertySetter(containerJavaType, propertyName, setterMethod);
                break;
            }
            default: {
                throw new PropertyAccessBuildingException("Invalid access type " + propertyAccessType + " for property named [" + containerJavaType.getName() + "#" + propertyName + "]");
            }
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized Getter fieldGetter(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerJavaType, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized Field field) {
        return new GetterFieldImpl(containerJavaType, propertyName, field);
    }

    private static @UnknownKeyFor @NonNull @Initialized Setter fieldSetter(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerJavaType, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized Field field) {
        return new SetterFieldImpl(containerJavaType, propertyName, field);
    }

    private static @UnknownKeyFor @NonNull @Initialized Getter propertyGetter(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerJavaType, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized Method method) {
        return new GetterMethodImpl(containerJavaType, propertyName, method);
    }

    private static @PolyNull @UnknownKeyFor @Initialized Setter propertySetter(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerJavaType, @UnknownKeyFor @NonNull @Initialized String propertyName, @PolyNull @UnknownKeyFor @Initialized Method method) {
        return method == null ? null : new SetterMethodImpl(containerJavaType, propertyName, method);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PropertyAccessStrategy getPropertyAccessStrategy() {
        return this.strategy;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Getter getGetter() {
        return this.getter;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Setter getSetter() {
        return this.setter;
    }
}

