/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection.mutation;

import java.util.Iterator;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.spi.BatchKeyAccess;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.OneToManyPersister;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.persister.collection.mutation.CollectionTableMapping;
import org.hibernate.persister.collection.mutation.InsertRowsCoordinator;
import org.hibernate.persister.collection.mutation.RowMutationOperations;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.internal.MutationOperationGroupFactory;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;

public class InsertRowsCoordinatorTablePerSubclass
implements InsertRowsCoordinator {
    private final CollectionMutationTarget mutationTarget;
    private final RowMutationOperations rowMutationOperations;
    private final SubclassEntry[] subclassEntries;
    private final MutationExecutorService mutationExecutorService;

    public InsertRowsCoordinatorTablePerSubclass(OneToManyPersister mutationTarget, RowMutationOperations rowMutationOperations, ServiceRegistry serviceRegistry) {
        this.mutationTarget = mutationTarget;
        this.rowMutationOperations = rowMutationOperations;
        this.subclassEntries = new SubclassEntry[mutationTarget.getElementPersister().getRootEntityDescriptor().getSubclassEntityNames().size()];
        this.mutationExecutorService = serviceRegistry.getService(MutationExecutorService.class);
    }

    public String toString() {
        return "InsertRowsCoordinator(" + this.mutationTarget.getRolePath() + ")";
    }

    @Override
    public CollectionMutationTarget getMutationTarget() {
        return this.mutationTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertRows(PersistentCollection<?> collection, Object id, InsertRowsCoordinator.EntryFilter entryChecker, SharedSessionContractImplementor session) {
        boolean loggerDebugEnabled = ModelMutationLogging.MODEL_MUTATION_LOGGER.isDebugEnabled();
        if (loggerDebugEnabled) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Inserting collection rows - %s : %s", (Object)this.mutationTarget.getRolePath(), id);
        }
        PluralAttributeMapping pluralAttribute = this.mutationTarget.getTargetPart();
        CollectionPersister collectionDescriptor = pluralAttribute.getCollectionDescriptor();
        Iterator<?> entries = collection.entries(collectionDescriptor);
        collection.preInsert(collectionDescriptor);
        if (!entries.hasNext()) {
            if (loggerDebugEnabled) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("No collection rows to insert - %s : %s", (Object)this.mutationTarget.getRolePath(), id);
            }
            return;
        }
        MutationExecutor[] executors = new MutationExecutor[this.subclassEntries.length];
        try {
            int entryCount = 0;
            while (entries.hasNext()) {
                Object entry = entries.next();
                if (entryChecker == null || entryChecker.include(entry, entryCount, collection, pluralAttribute)) {
                    MutationExecutor mutationExecutor;
                    EntityEntry entityEntry = session.getPersistenceContextInternal().getEntry(entry);
                    int subclassId = entityEntry.getPersister().getSubclassId();
                    if (executors[subclassId] == null) {
                        SubclassEntry subclassEntry = this.getSubclassEntry(entityEntry.getPersister());
                        mutationExecutor = executors[subclassId] = this.mutationExecutorService.createExecutor(subclassEntry.batchKeySupplier, subclassEntry.operationGroup, session);
                    } else {
                        mutationExecutor = executors[subclassId];
                    }
                    this.rowMutationOperations.getInsertRowValues().applyValues(collection, id, entry, entryCount, session, mutationExecutor.getJdbcValueBindings());
                    mutationExecutor.execute(entry, null, null, null, session);
                }
                ++entryCount;
            }
            if (loggerDebugEnabled) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Done inserting `%s` collection rows : %s", entryCount, (Object)this.mutationTarget.getRolePath());
            }
        }
        finally {
            for (MutationExecutor executor : executors) {
                if (executor == null) continue;
                executor.release();
            }
        }
    }

    private SubclassEntry getSubclassEntry(EntityPersister elementPersister) {
        int subclassId = elementPersister.getSubclassId();
        SubclassEntry subclassEntry = this.subclassEntries[subclassId];
        if (subclassEntry != null) {
            return subclassEntry;
        }
        BasicBatchKey basicBatchKey = new BasicBatchKey(this.mutationTarget.getRolePath() + "#INSERT#" + subclassId);
        this.subclassEntries[subclassId] = new SubclassEntry(() -> basicBatchKey, this.createOperationGroup(elementPersister));
        return this.subclassEntries[subclassId];
    }

    private MutationOperationGroup createOperationGroup(EntityPersister elementPersister) {
        assert (this.mutationTarget.getTargetPart() != null);
        assert (this.mutationTarget.getTargetPart().getKeyDescriptor() != null);
        CollectionTableMapping collectionTableMapping = this.mutationTarget.getCollectionTableMapping();
        JdbcMutationOperation operation = this.rowMutationOperations.getInsertRowOperation(new CollectionTableMapping(elementPersister.getMappedTableDetails().getTableName(), collectionTableMapping.getSpaces(), collectionTableMapping.isJoinTable(), collectionTableMapping.isInverse(), collectionTableMapping.getInsertDetails(), collectionTableMapping.getUpdateDetails(), collectionTableMapping.isCascadeDeleteEnabled(), collectionTableMapping.getDeleteDetails(), collectionTableMapping.getDeleteRowDetails()));
        return MutationOperationGroupFactory.singleOperation(MutationType.INSERT, this.mutationTarget, operation);
    }

    private static class SubclassEntry {
        private final BatchKeyAccess batchKeySupplier;
        private final MutationOperationGroup operationGroup;

        public SubclassEntry(BatchKeyAccess batchKeySupplier, MutationOperationGroup operationGroup) {
            this.batchKeySupplier = batchKeySupplier;
            this.operationGroup = operationGroup;
        }
    }
}

