/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.config.spi;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.engine.config.spi.ConfigurationService;

public class StandardConverters {
    public static final @UnknownKeyFor @NonNull @Initialized ConfigurationService.Converter<@UnknownKeyFor @NonNull @Initialized Boolean> BOOLEAN = StandardConverters::asBoolean;
    public static final @UnknownKeyFor @NonNull @Initialized ConfigurationService.Converter<@UnknownKeyFor @NonNull @Initialized String> STRING = StandardConverters::asString;
    public static final @UnknownKeyFor @NonNull @Initialized ConfigurationService.Converter<@UnknownKeyFor @NonNull @Initialized Integer> INTEGER = StandardConverters::asInteger;

    public static @UnknownKeyFor @NonNull @Initialized Boolean asBoolean(@UnknownKeyFor @NonNull @Initialized Object value) {
        return value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean(value.toString());
    }

    public static @UnknownKeyFor @NonNull @Initialized String asString(@UnknownKeyFor @NonNull @Initialized Object value) {
        return value.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized Integer asInteger(@UnknownKeyFor @NonNull @Initialized Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.parseInt(value.toString());
    }

    private StandardConverters() {
    }
}

