/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.internal.util.config.ConfigurationHelper;

public class OracleServerConfiguration {
    private final boolean autonomous;
    private final boolean extended;

    public boolean isAutonomous() {
        return this.autonomous;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public OracleServerConfiguration(boolean autonomous, boolean extended) {
        this.autonomous = autonomous;
        this.extended = extended;
    }

    public static OracleServerConfiguration fromDialectResolutionInfo(DialectResolutionInfo info) {
        Boolean extended = null;
        Boolean autonomous = null;
        DatabaseMetaData databaseMetaData = info.getDatabaseMetadata();
        if (databaseMetaData != null) {
            try (Statement statement = databaseMetaData.getConnection().createStatement();){
                ResultSet rs = statement.executeQuery("select cast('string' as varchar2(32000)), sys_context('USERENV','CLOUD_SERVICE') from dual");
                if (rs.next()) {
                    extended = true;
                    autonomous = OracleServerConfiguration.isAutonomous(rs.getString(2));
                }
            }
            catch (SQLException ex) {
                extended = false;
                autonomous = OracleServerConfiguration.isAutonomous(databaseMetaData);
            }
        }
        if (extended == null) {
            extended = ConfigurationHelper.getBoolean("hibernate.dialect.oracle.extended_string_size", info.getConfigurationValues(), false);
        }
        if (autonomous == null) {
            autonomous = ConfigurationHelper.getBoolean("hibernate.dialect.oracle.is_autonomous", info.getConfigurationValues(), false);
        }
        return new OracleServerConfiguration(autonomous, extended);
    }

    private static boolean isAutonomous(String cloudServiceParam) {
        return cloudServiceParam != null && List.of("OLTP", "DWCS", "JDCS").contains(cloudServiceParam);
    }

    private static boolean isAutonomous(DatabaseMetaData databaseMetaData) {
        boolean bl;
        block8: {
            Statement statement = databaseMetaData.getConnection().createStatement();
            try {
                bl = statement.executeQuery("select 1 from dual where sys_context('USERENV','CLOUD_SERVICE') in ('OLTP','DWCS','JDCS')").next();
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    return false;
                }
            }
            statement.close();
        }
        return bl;
    }
}

