/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.Properties;
import org.hibernate.boot.BootLogging;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.usertype.ParameterizedType;

public class DelayedParameterizedTypeBean<T>
implements ManagedBean<T> {
    private final ManagedBean<T> underlyingBean;
    private final Properties properties;
    private T instance;

    public DelayedParameterizedTypeBean(ManagedBean<T> underlyingBean, Properties properties) {
        assert (ParameterizedType.class.isAssignableFrom(underlyingBean.getBeanClass()));
        this.underlyingBean = underlyingBean;
        this.properties = properties;
    }

    @Override
    public Class<T> getBeanClass() {
        return this.underlyingBean.getBeanClass();
    }

    @Override
    public T getBeanInstance() {
        if (this.instance == null) {
            this.instance = this.underlyingBean.getBeanInstance();
            ((ParameterizedType)this.instance).setParameterValues(this.properties);
        }
        return this.instance;
    }

    public static <T> ManagedBean<T> delayedConfigBean(String role, ManagedBean<T> bean, Properties properties) {
        if (CollectionHelper.isNotEmpty(properties)) {
            if (ParameterizedType.class.isAssignableFrom(bean.getBeanClass())) {
                return new DelayedParameterizedTypeBean<T>(bean, properties);
            }
            BootLogging.BOOT_LOGGER.debugf("`@CollectionType` (%s) specified parameters, but the implementation does not implement `%s` which is used to inject them - `%s`", (Object)role, (Object)ParameterizedType.class.getName(), (Object)bean.getBeanClass().getName());
        }
        return bean;
    }
}

