/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.net;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingConsumerHandler;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.TrafficShapingOptions;
import io.vertx.mutiny.core.metrics.Measured;
import io.vertx.mutiny.core.net.NetSocket;
import io.vertx.mutiny.core.net.SocketAddress;
import io.vertx.mutiny.core.streams.ReadStream;
import java.util.function.Consumer;

@MutinyGen(value=io.vertx.core.net.NetServer.class)
public class NetServer
implements Measured {
    public static final TypeArg<NetServer> __TYPE_ARG = new TypeArg(obj -> new NetServer((io.vertx.core.net.NetServer)obj), NetServer::getDelegate);
    private final io.vertx.core.net.NetServer delegate;
    static final TypeArg<NetSocket> TYPE_ARG_0 = new TypeArg(o1 -> NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());

    public NetServer(io.vertx.core.net.NetServer delegate) {
        this.delegate = delegate;
    }

    public NetServer(Object delegate) {
        this.delegate = (io.vertx.core.net.NetServer)delegate;
    }

    NetServer() {
        this.delegate = null;
    }

    public io.vertx.core.net.NetServer getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetServer that = (NetServer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    @Deprecated
    public ReadStream<NetSocket> connectStream() {
        ReadStream<NetSocket> ret = ReadStream.newInstance(this.delegate.connectStream(), TYPE_ARG_0);
        return ret;
    }

    private NetServer __connectHandler(Handler<NetSocket> handler) {
        NetServer ret = NetServer.newInstance(this.delegate.connectHandler((Handler)new DelegatingHandler(handler, event -> NetSocket.newInstance(event))));
        return ret;
    }

    public NetServer connectHandler(Consumer<NetSocket> handler) {
        return this.__connectHandler((Handler<NetSocket>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @CheckReturnValue
    public Uni<NetServer> listen() {
        return AsyncResultUni.toUni(listenHandler -> this.delegate.listen((Handler)new DelegatingHandler(listenHandler, ar -> ar.map(event -> NetServer.newInstance(event)))));
    }

    public NetServer listenAndAwait() {
        return (NetServer)this.listen().await().indefinitely();
    }

    @Fluent
    public NetServer listenAndForget() {
        this.listen().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<NetServer> listen(int port, String host) {
        return AsyncResultUni.toUni(listenHandler -> this.delegate.listen(port, host, (Handler)new DelegatingHandler(listenHandler, ar -> ar.map(event -> NetServer.newInstance(event)))));
    }

    public NetServer listenAndAwait(int port, String host) {
        return (NetServer)this.listen(port, host).await().indefinitely();
    }

    @Fluent
    public NetServer listenAndForget(int port, String host) {
        this.listen(port, host).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<NetServer> listen(int port) {
        return AsyncResultUni.toUni(listenHandler -> this.delegate.listen(port, (Handler)new DelegatingHandler(listenHandler, ar -> ar.map(event -> NetServer.newInstance(event)))));
    }

    public NetServer listenAndAwait(int port) {
        return (NetServer)this.listen(port).await().indefinitely();
    }

    @Fluent
    public NetServer listenAndForget(int port) {
        this.listen(port).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<NetServer> listen(SocketAddress localAddress) {
        return AsyncResultUni.toUni(listenHandler -> this.delegate.listen(localAddress.getDelegate(), (Handler)new DelegatingHandler(listenHandler, ar -> ar.map(event -> NetServer.newInstance(event)))));
    }

    public NetServer listenAndAwait(SocketAddress localAddress) {
        return (NetServer)this.listen(localAddress).await().indefinitely();
    }

    @Fluent
    public NetServer listenAndForget(SocketAddress localAddress) {
        this.listen(localAddress).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.close(completionHandler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    public int actualPort() {
        int ret = this.delegate.actualPort();
        return ret;
    }

    @CheckReturnValue
    public Uni<Boolean> updateSSLOptions(SSLOptions options) {
        return AsyncResultUni.toUni(handler -> this.delegate.updateSSLOptions(options, handler));
    }

    public Boolean updateSSLOptionsAndAwait(SSLOptions options) {
        return (Boolean)this.updateSSLOptions(options).await().indefinitely();
    }

    public void updateSSLOptionsAndForget(SSLOptions options) {
        this.updateSSLOptions(options).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Boolean> updateSSLOptions(SSLOptions options, boolean force) {
        return AsyncResultUni.toUni(handler -> this.delegate.updateSSLOptions(options, force, handler));
    }

    public Boolean updateSSLOptionsAndAwait(SSLOptions options, boolean force) {
        return (Boolean)this.updateSSLOptions(options, force).await().indefinitely();
    }

    public void updateSSLOptionsAndForget(SSLOptions options, boolean force) {
        this.updateSSLOptions(options, force).subscribe().with(UniHelper.NOOP);
    }

    public void updateTrafficShapingOptions(TrafficShapingOptions options) {
        this.delegate.updateTrafficShapingOptions(options);
    }

    public static NetServer newInstance(io.vertx.core.net.NetServer arg) {
        return arg != null ? new NetServer(arg) : null;
    }
}

