/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.session;

import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionFactory;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;

public class JTASessionOpener {
    private final SessionFactory sessionFactory;
    private final SessionBuilder cachedOptions;

    public static JTASessionOpener create(SessionFactory sessionFactory) {
        CurrentTenantIdentifierResolver currentTenantIdentifierResolver = ((SessionFactoryImplementor)sessionFactory.unwrap(SessionFactoryImplementor.class)).getCurrentTenantIdentifierResolver();
        if (currentTenantIdentifierResolver == null) {
            return new JTASessionOpener(sessionFactory, JTASessionOpener.createOptions(sessionFactory));
        }
        return new JTASessionOpener(sessionFactory, null);
    }

    private static SessionBuilder createOptions(SessionFactory sessionFactory) {
        return sessionFactory.withOptions().autoClose(true).connectionHandlingMode(PhysicalConnectionHandlingMode.DELAYED_ACQUISITION_AND_RELEASE_BEFORE_TRANSACTION_COMPLETION).flushMode(FlushMode.ALWAYS);
    }

    public JTASessionOpener(SessionFactory sessionFactory, SessionBuilder cachedOptions) {
        this.sessionFactory = sessionFactory;
        this.cachedOptions = cachedOptions;
    }

    public Session openSession() {
        SessionBuilder options = this.cachedOptions != null ? this.cachedOptions : JTASessionOpener.createOptions(this.sessionFactory);
        return options.openSession();
    }
}

