/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metrics.impl;

import java.net.InetAddress;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.infinispan.commons.stat.MetricInfo;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metrics.Constants;
import org.infinispan.metrics.impl.MetricsRegistry;
import org.infinispan.remoting.transport.Transport;

@Scope(value=Scopes.GLOBAL)
@SurvivesRestarts
public class MetricsCollector
implements Constants {
    @Inject
    MetricsRegistry metricsRegistry;
    @Inject
    GlobalConfiguration globalConfig;
    @Inject
    ComponentRef<Transport> transportRef;
    private String nodeName;

    MetricsCollector() {
    }

    @Start
    protected void start() {
        Transport transport = this.transportRef.running();
        String string = this.nodeName = transport != null ? transport.getAddress().toString() : this.globalConfig.transport().nodeName();
        if (this.nodeName == null) {
            this.nodeName = MetricsCollector.generateRandomName();
        }
    }

    private static String generateRandomName() {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (hostName == null) {
            try {
                hostName = InetAddress.getByName(null).getHostName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (hostName == null) {
            hostName = "localhost";
        } else {
            int dotPos = hostName.indexOf(46);
            if (dotPos > 0 && !Character.isDigit(hostName.charAt(0))) {
                hostName = hostName.substring(0, dotPos);
            }
        }
        int rand = 1 + ThreadLocalRandom.current().nextInt(65534);
        return hostName + "-" + rand;
    }

    public Set<Object> registerMetrics(Object instance, Collection<MetricInfo> metrics, String namePrefix, String cacheName) {
        Map<String, String> tags = cacheName != null ? Map.of("cache", cacheName, "node", this.nodeName) : Map.of("node", this.nodeName);
        return this.metricsRegistry.registerMetrics(instance, metrics, namePrefix, tags);
    }

    public void unregisterMetric(Object metricId) {
        this.metricsRegistry.unregisterMetric(metricId);
    }
}

