/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.security.Permission;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class RolesAllowedHttpSecurityPolicy
implements HttpSecurityPolicy {
    private static final String AUTHENTICATED = "**";
    private final String[] rolesAllowed;
    private final boolean grantPermissions;
    private final boolean grantRoles;
    private final Map<String, Set<Permission>> roleToPermissions;
    private final Map<String, List<String>> roleToRoles;

    public RolesAllowedHttpSecurityPolicy(List<String> rolesAllowed, Map<String, Set<Permission>> roleToPermissions, Map<String, List<String>> roleToRoles) {
        if (roleToPermissions != null && !roleToPermissions.isEmpty()) {
            this.grantPermissions = true;
            this.roleToPermissions = Map.copyOf(roleToPermissions);
        } else {
            this.grantPermissions = false;
            this.roleToPermissions = null;
        }
        if (roleToRoles != null && !roleToRoles.isEmpty()) {
            this.grantRoles = true;
            this.roleToRoles = Map.copyOf(roleToRoles);
        } else {
            this.grantRoles = false;
            this.roleToRoles = null;
        }
        this.rolesAllowed = (String[])rolesAllowed.toArray(String[]::new);
    }

    @Override
    public Uni<HttpSecurityPolicy.CheckResult> checkPermission(RoutingContext request, Uni<SecurityIdentity> identity, HttpSecurityPolicy.AuthorizationRequestContext requestContext) {
        return identity.map((Function)new Function<SecurityIdentity, HttpSecurityPolicy.CheckResult>(){

            @Override
            public HttpSecurityPolicy.CheckResult apply(SecurityIdentity securityIdentity) {
                SecurityIdentity augmented;
                if ((RolesAllowedHttpSecurityPolicy.this.grantPermissions || RolesAllowedHttpSecurityPolicy.this.grantRoles) && (augmented = RolesAllowedHttpSecurityPolicy.this.augmentIdentity(securityIdentity)) != null) {
                    for (String i : RolesAllowedHttpSecurityPolicy.this.rolesAllowed) {
                        if (!augmented.hasRole(i) && (!RolesAllowedHttpSecurityPolicy.AUTHENTICATED.equals(i) || augmented.isAnonymous())) continue;
                        return new HttpSecurityPolicy.CheckResult(true, augmented);
                    }
                    return HttpSecurityPolicy.CheckResult.DENY;
                }
                for (String i : RolesAllowedHttpSecurityPolicy.this.rolesAllowed) {
                    if (!securityIdentity.hasRole(i) && (!RolesAllowedHttpSecurityPolicy.AUTHENTICATED.equals(i) || securityIdentity.isAnonymous())) continue;
                    return HttpSecurityPolicy.CheckResult.PERMIT;
                }
                return HttpSecurityPolicy.CheckResult.DENY;
            }
        });
    }

    private SecurityIdentity augmentIdentity(SecurityIdentity securityIdentity) {
        Set roles = securityIdentity.getRoles();
        if (roles != null && !roles.isEmpty()) {
            boolean addPerms;
            HashSet<Permission> permissions = this.grantPermissions ? new HashSet<Permission>() : null;
            HashSet newRoles = this.grantRoles ? new HashSet() : null;
            for (String role : roles) {
                if (this.grantPermissions && this.roleToPermissions.containsKey(role)) {
                    permissions.addAll((Collection<Permission>)this.roleToPermissions.get(role));
                }
                if (!this.grantRoles || !this.roleToRoles.containsKey(role)) continue;
                newRoles.addAll(this.roleToRoles.get(role));
            }
            boolean bl = addPerms = this.grantPermissions && !permissions.isEmpty();
            if (this.grantRoles && !newRoles.isEmpty()) {
                newRoles.addAll(roles);
                return RolesAllowedHttpSecurityPolicy.augmentIdentity(securityIdentity, permissions, Set.copyOf(newRoles), addPerms);
            }
            if (addPerms) {
                return RolesAllowedHttpSecurityPolicy.augmentIdentity(securityIdentity, permissions, roles, true);
            }
        }
        return null;
    }

    private static SecurityIdentity augmentIdentity(final SecurityIdentity securityIdentity, final Set<Permission> permissions, final Set<String> roles, final boolean addPerms) {
        return new SecurityIdentity(){

            public Principal getPrincipal() {
                return securityIdentity.getPrincipal();
            }

            public boolean isAnonymous() {
                return securityIdentity.isAnonymous();
            }

            public Set<String> getRoles() {
                return roles;
            }

            public boolean hasRole(String s) {
                return roles.contains(s);
            }

            public <T extends Credential> T getCredential(Class<T> aClass) {
                return (T)securityIdentity.getCredential(aClass);
            }

            public Set<Credential> getCredentials() {
                return securityIdentity.getCredentials();
            }

            public <T> T getAttribute(String s) {
                return (T)securityIdentity.getAttribute(s);
            }

            public Map<String, Object> getAttributes() {
                return securityIdentity.getAttributes();
            }

            public Uni<Boolean> checkPermission(Permission requiredPermission) {
                if (addPerms) {
                    for (Permission possessedPermission : permissions) {
                        if (!possessedPermission.implies(requiredPermission)) continue;
                        return Uni.createFrom().item((Object)true);
                    }
                }
                return securityIdentity.checkPermission(requiredPermission);
            }

            public boolean checkPermissionBlocking(Permission requiredPermission) {
                if (addPerms) {
                    for (Permission possessedPermission : permissions) {
                        if (!possessedPermission.implies(requiredPermission)) continue;
                        return true;
                    }
                }
                return securityIdentity.checkPermissionBlocking(requiredPermission);
            }
        };
    }
}

