/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.attribute;

import io.quarkus.vertx.http.runtime.attribute.ExchangeAttribute;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeWrapper;
import io.quarkus.vertx.http.runtime.attribute.ReadOnlyAttributeException;
import io.vertx.ext.web.RoutingContext;

public class QuotingExchangeAttribute
implements ExchangeAttribute {
    private final ExchangeAttribute exchangeAttribute;
    public static final ExchangeAttributeWrapper WRAPPER = new Wrapper();

    public QuotingExchangeAttribute(ExchangeAttribute exchangeAttribute) {
        this.exchangeAttribute = exchangeAttribute;
    }

    @Override
    public String readAttribute(RoutingContext exchange) {
        String svalue = this.exchangeAttribute.readAttribute(exchange);
        if (svalue == null || "-".equals(svalue) || svalue.isEmpty()) {
            return "-";
        }
        StringBuilder buffer = new StringBuilder(svalue.length() + 2);
        buffer.append('\'');
        int i = 0;
        while (i < svalue.length()) {
            int j = svalue.indexOf(39, i);
            if (j == -1) {
                buffer.append(svalue.substring(i));
                i = svalue.length();
                continue;
            }
            buffer.append(svalue.substring(i, j + 1));
            buffer.append('\"');
            i = j + 2;
        }
        buffer.append('\'');
        return buffer.toString();
    }

    @Override
    public void writeAttribute(RoutingContext exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException();
    }

    public static class Wrapper
    implements ExchangeAttributeWrapper {
        @Override
        public ExchangeAttribute wrap(ExchangeAttribute attribute) {
            return new QuotingExchangeAttribute(attribute);
        }
    }
}

