/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class MaybeConcatArray<T>
extends Flowable<T> {
    final MaybeSource<? extends T>[] sources;

    public MaybeConcatArray(MaybeSource<? extends T>[] sources) {
        this.sources = sources;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        ConcatMaybeObserver<T> parent = new ConcatMaybeObserver<T>(s, this.sources);
        s.onSubscribe(parent);
        parent.drain();
    }

    static final class ConcatMaybeObserver<T>
    extends AtomicInteger
    implements MaybeObserver<T>,
    Subscription {
        private static final long serialVersionUID = 3520831347801429610L;
        final Subscriber<? super T> downstream;
        final AtomicLong requested;
        final AtomicReference<Object> current;
        final SequentialDisposable disposables;
        final MaybeSource<? extends T>[] sources;
        int index;
        long produced;

        ConcatMaybeObserver(Subscriber<? super T> actual, MaybeSource<? extends T>[] sources) {
            this.downstream = actual;
            this.sources = sources;
            this.requested = new AtomicLong();
            this.disposables = new SequentialDisposable();
            this.current = new AtomicReference<NotificationLite>(NotificationLite.COMPLETE);
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        public void cancel() {
            this.disposables.dispose();
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.disposables.replace(d);
        }

        @Override
        public void onSuccess(T value) {
            this.current.lazySet(value);
            this.drain();
        }

        @Override
        public void onError(Throwable e) {
            this.downstream.onError(e);
        }

        @Override
        public void onComplete() {
            this.current.lazySet((Object)NotificationLite.COMPLETE);
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            AtomicReference<Object> c = this.current;
            Subscriber<? super T> a = this.downstream;
            SequentialDisposable cancelled = this.disposables;
            do {
                boolean goNextSource;
                if (cancelled.isDisposed()) {
                    c.lazySet(null);
                    return;
                }
                Object o = c.get();
                if (o == null) continue;
                if (o != NotificationLite.COMPLETE) {
                    long p = this.produced;
                    if (p != this.requested.get()) {
                        this.produced = p + 1L;
                        c.lazySet(null);
                        goNextSource = true;
                        a.onNext(o);
                    } else {
                        goNextSource = false;
                    }
                } else {
                    goNextSource = true;
                    c.lazySet(null);
                }
                if (!goNextSource || cancelled.isDisposed()) continue;
                int i = this.index;
                if (i == this.sources.length) {
                    a.onComplete();
                    return;
                }
                this.index = i + 1;
                this.sources[i].subscribe(this);
            } while (this.decrementAndGet() != 0);
        }
    }
}

