/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import jakarta.ws.rs.container.ResourceInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import org.jboss.jandex.MethodInfo;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class FilterClassIntrospector {
    private final ClassLoader classLoader;

    public FilterClassIntrospector(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean usesGetResourceMethod(MethodInfo methodInfo) {
        boolean bl;
        block8: {
            String className = methodInfo.declaringClass().name().toString();
            InputStream is = this.classLoader.getResourceAsStream(className.replace('.', '/') + ".class");
            try {
                ClassReader configClassReader = new ClassReader(is);
                FilterClassVisitor classVisitor = new FilterClassVisitor(methodInfo.descriptor());
                configClassReader.accept((ClassVisitor)classVisitor, 0);
                bl = classVisitor.usesGetResourceMethod();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(className + " class reading failed", e);
                }
            }
            is.close();
        }
        return bl;
    }

    private static class FilterClassVisitor
    extends ClassVisitor {
        private final String methodDescriptor;
        private final UsesGetResourceMethodVisitor methodVisitor = new UsesGetResourceMethodVisitor();

        private FilterClassVisitor(String methodDescriptor) {
            super(589824);
            this.methodDescriptor = methodDescriptor;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor superMethodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
            if (this.methodDescriptor.equals(descriptor)) {
                return this.methodVisitor;
            }
            return superMethodVisitor;
        }

        public boolean usesGetResourceMethod() {
            return this.methodVisitor.usesGetResourceMethod;
        }
    }

    private static class UsesGetResourceMethodVisitor
    extends MethodVisitor {
        private boolean usesGetResourceMethod = false;

        private UsesGetResourceMethodVisitor() {
            super(589824);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            if (opcode == 185 && ResourceInfo.class.getName().replace('.', '/').equals(owner) && "getResourceMethod".equals(name)) {
                this.usesGetResourceMethod = true;
            }
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }
    }
}

