/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.permission;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.policy.provider.permission.UMAPolicyProvider;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.ClientPolicyRepresentation;
import org.keycloak.representations.idm.authorization.GroupPolicyRepresentation;
import org.keycloak.representations.idm.authorization.JSPolicyRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.RolePolicyRepresentation;
import org.keycloak.representations.idm.authorization.UmaPermissionRepresentation;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;

public class UMAPolicyProviderFactory
implements PolicyProviderFactory<UmaPermissionRepresentation> {
    private UMAPolicyProvider provider = new UMAPolicyProvider();

    public String getName() {
        return "UMA";
    }

    public String getGroup() {
        return "Others";
    }

    public boolean isInternal() {
        return true;
    }

    public PolicyProvider create(AuthorizationProvider authorization) {
        return this.provider;
    }

    public PolicyProvider create(KeycloakSession session) {
        return this.provider;
    }

    public void onCreate(Policy policy, UmaPermissionRepresentation representation, AuthorizationProvider authorization) {
        String condition;
        Set users;
        Set clients;
        Set groups;
        policy.setOwner(representation.getOwner());
        PolicyStore policyStore = authorization.getStoreFactory().getPolicyStore();
        Set roles = representation.getRoles();
        if (roles != null) {
            for (Object role : roles) {
                this.createRolePolicy(policy, policyStore, (String)role, representation.getOwner());
            }
        }
        if ((groups = representation.getGroups()) != null) {
            for (Object group : groups) {
                this.createGroupPolicy(policy, policyStore, (String)group, representation.getOwner());
            }
        }
        if ((clients = representation.getClients()) != null) {
            for (Object client : clients) {
                this.createClientPolicy(policy, policyStore, (String)client, representation.getOwner());
            }
        }
        if ((users = representation.getUsers()) != null) {
            for (String user : users) {
                this.createUserPolicy(policy, policyStore, user, representation.getOwner());
            }
        }
        if ((condition = representation.getCondition()) != null) {
            this.createJSPolicy(policy, policyStore, condition, representation.getOwner());
        }
    }

    public void onUpdate(Policy policy, UmaPermissionRepresentation representation, AuthorizationProvider authorization) {
        String condition;
        Set updatedUsers;
        Set updatedClients;
        Set updatedGroups;
        PolicyStore policyStore = authorization.getStoreFactory().getPolicyStore();
        Set associatedPolicies = policy.getAssociatedPolicies();
        for (Policy associatedPolicy : associatedPolicies) {
            RolePolicyRepresentation rep;
            AbstractPolicyRepresentation associatedRep = ModelToRepresentation.toRepresentation((Policy)associatedPolicy, (AuthorizationProvider)authorization, (boolean)false, (boolean)false);
            if ("role".equals(associatedRep.getType())) {
                rep = (RolePolicyRepresentation)RolePolicyRepresentation.class.cast(associatedRep);
                rep.setRoles(new HashSet());
                Set updatedRoles = representation.getRoles();
                if (updatedRoles != null) {
                    for (String role : updatedRoles) {
                        rep.addRole(role);
                    }
                }
                if (rep.getRoles().isEmpty()) {
                    policyStore.delete(associatedPolicy.getId());
                    continue;
                }
                RepresentationToModel.toModel((AbstractPolicyRepresentation)rep, (AuthorizationProvider)authorization, (Policy)associatedPolicy);
                continue;
            }
            if (associatedRep instanceof JSPolicyRepresentation) {
                rep = (JSPolicyRepresentation)JSPolicyRepresentation.class.cast(associatedRep);
                if (representation.getCondition() != null) {
                    rep.setType(representation.getCondition());
                    RepresentationToModel.toModel((AbstractPolicyRepresentation)rep, (AuthorizationProvider)authorization, (Policy)associatedPolicy);
                    continue;
                }
                policyStore.delete(associatedPolicy.getId());
                continue;
            }
            if ("group".equals(associatedRep.getType())) {
                rep = (GroupPolicyRepresentation)GroupPolicyRepresentation.class.cast(associatedRep);
                rep.setGroups(new HashSet());
                Set updatedGroups2 = representation.getGroups();
                if (updatedGroups2 != null) {
                    for (String group : updatedGroups2) {
                        rep.addGroupPath(new String[]{group});
                    }
                }
                if (rep.getGroups().isEmpty()) {
                    policyStore.delete(associatedPolicy.getId());
                    continue;
                }
                RepresentationToModel.toModel((AbstractPolicyRepresentation)rep, (AuthorizationProvider)authorization, (Policy)associatedPolicy);
                continue;
            }
            if ("client".equals(associatedRep.getType())) {
                rep = (ClientPolicyRepresentation)ClientPolicyRepresentation.class.cast(associatedRep);
                rep.setClients(new HashSet());
                Set updatedClients2 = representation.getClients();
                if (updatedClients2 != null) {
                    for (String client : updatedClients2) {
                        rep.addClient(new String[]{client});
                    }
                }
                if (rep.getClients().isEmpty()) {
                    policyStore.delete(associatedPolicy.getId());
                    continue;
                }
                RepresentationToModel.toModel((AbstractPolicyRepresentation)rep, (AuthorizationProvider)authorization, (Policy)associatedPolicy);
                continue;
            }
            if (!"user".equals(associatedRep.getType())) continue;
            rep = (UserPolicyRepresentation)UserPolicyRepresentation.class.cast(associatedRep);
            rep.setUsers(new HashSet());
            Set updatedUsers2 = representation.getUsers();
            if (updatedUsers2 != null) {
                for (String user : updatedUsers2) {
                    rep.addUser(user);
                }
            }
            if (rep.getUsers().isEmpty()) {
                policyStore.delete(associatedPolicy.getId());
                continue;
            }
            RepresentationToModel.toModel((AbstractPolicyRepresentation)rep, (AuthorizationProvider)authorization, (Policy)associatedPolicy);
        }
        Set updatedRoles = representation.getRoles();
        if (updatedRoles != null) {
            boolean createPolicy = true;
            for (Policy associatedPolicy : associatedPolicies) {
                if (!"role".equals(associatedPolicy.getType())) continue;
                createPolicy = false;
            }
            if (createPolicy) {
                for (Object role : updatedRoles) {
                    this.createRolePolicy(policy, policyStore, (String)role, policy.getOwner());
                }
            }
        }
        if ((updatedGroups = representation.getGroups()) != null) {
            boolean createPolicy = true;
            for (Policy associatedPolicy : associatedPolicies) {
                if (!"group".equals(associatedPolicy.getType())) continue;
                createPolicy = false;
            }
            if (createPolicy) {
                for (Object group : updatedGroups) {
                    this.createGroupPolicy(policy, policyStore, (String)group, policy.getOwner());
                }
            }
        }
        if ((updatedClients = representation.getClients()) != null) {
            boolean createPolicy = true;
            for (Policy associatedPolicy : associatedPolicies) {
                if (!"client".equals(associatedPolicy.getType())) continue;
                createPolicy = false;
            }
            if (createPolicy) {
                for (Object client : updatedClients) {
                    this.createClientPolicy(policy, policyStore, (String)client, policy.getOwner());
                }
            }
        }
        if ((updatedUsers = representation.getUsers()) != null) {
            boolean createPolicy = true;
            for (Policy associatedPolicy : associatedPolicies) {
                if (!"user".equals(associatedPolicy.getType())) continue;
                createPolicy = false;
            }
            if (createPolicy) {
                for (String user : updatedUsers) {
                    this.createUserPolicy(policy, policyStore, user, policy.getOwner());
                }
            }
        }
        if ((condition = representation.getCondition()) != null) {
            boolean createPolicy = true;
            for (Policy associatedPolicy : associatedPolicies) {
                if (!associatedPolicy.getType().startsWith("script-")) continue;
                createPolicy = false;
            }
            if (createPolicy) {
                this.createJSPolicy(policy, policyStore, condition, policy.getOwner());
            }
        }
    }

    public void onImport(Policy policy, PolicyRepresentation representation, AuthorizationProvider authorization) {
    }

    public UmaPermissionRepresentation toRepresentation(Policy policy, AuthorizationProvider authorization) {
        UmaPermissionRepresentation representation = new UmaPermissionRepresentation();
        representation.setScopes(policy.getScopes().stream().map(Scope::getName).collect(Collectors.toSet()));
        representation.setOwner(policy.getOwner());
        for (Policy associatedPolicy : policy.getAssociatedPolicies()) {
            RolePolicyRepresentation rep;
            AbstractPolicyRepresentation associatedRep = ModelToRepresentation.toRepresentation((Policy)associatedPolicy, (AuthorizationProvider)authorization, (boolean)false, (boolean)false);
            RealmModel realm = authorization.getRealm();
            if ("role".equals(associatedRep.getType())) {
                rep = (RolePolicyRepresentation)RolePolicyRepresentation.class.cast(associatedRep);
                for (RolePolicyRepresentation.RoleDefinition definition : rep.getRoles()) {
                    RoleModel role = realm.getRoleById(definition.getId());
                    if (role.isClientRole()) {
                        representation.addClientRole(((ClientModel)ClientModel.class.cast(role.getContainer())).getClientId(), role.getName());
                        continue;
                    }
                    representation.addRole(new String[]{role.getName()});
                }
                continue;
            }
            if (associatedRep instanceof JSPolicyRepresentation) {
                rep = (JSPolicyRepresentation)JSPolicyRepresentation.class.cast(associatedRep);
                representation.setCondition(rep.getType());
                continue;
            }
            if ("group".equals(associatedRep.getType())) {
                rep = (GroupPolicyRepresentation)GroupPolicyRepresentation.class.cast(associatedRep);
                for (RolePolicyRepresentation.RoleDefinition definition : rep.getGroups()) {
                    representation.addGroup(new String[]{ModelToRepresentation.buildGroupPath((GroupModel)realm.getGroupById(definition.getId()))});
                }
                continue;
            }
            if ("client".equals(associatedRep.getType())) {
                rep = (ClientPolicyRepresentation)ClientPolicyRepresentation.class.cast(associatedRep);
                for (String client : rep.getClients()) {
                    representation.addClient(new String[]{realm.getClientById(client).getClientId()});
                }
                continue;
            }
            if (!"user".equals(associatedPolicy.getType())) continue;
            rep = (UserPolicyRepresentation)UserPolicyRepresentation.class.cast(associatedRep);
            for (String user : rep.getUsers()) {
                representation.addUser(new String[]{authorization.getKeycloakSession().users().getUserById(realm, user).getUsername()});
            }
        }
        return representation;
    }

    public Class<UmaPermissionRepresentation> getRepresentationType() {
        return UmaPermissionRepresentation.class;
    }

    public void onRemove(Policy policy, AuthorizationProvider authorization) {
        PolicyStore policyStore = authorization.getStoreFactory().getPolicyStore();
        for (Policy associatedPolicy : policy.getAssociatedPolicies()) {
            policyStore.delete(associatedPolicy.getId());
        }
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "uma";
    }

    private void createJSPolicy(Policy policy, PolicyStore policyStore, String condition, String owner) {
        JSPolicyRepresentation rep = new JSPolicyRepresentation();
        rep.setName(KeycloakModelUtils.generateId());
        rep.setType(condition);
        Policy associatedPolicy = policyStore.create(policy.getResourceServer(), (AbstractPolicyRepresentation)rep);
        associatedPolicy.setOwner(owner);
        policy.addAssociatedPolicy(associatedPolicy);
    }

    private void createClientPolicy(Policy policy, PolicyStore policyStore, String client, String owner) {
        ClientPolicyRepresentation rep = new ClientPolicyRepresentation();
        rep.setName(KeycloakModelUtils.generateId());
        rep.addClient(new String[]{client});
        Policy associatedPolicy = policyStore.create(policy.getResourceServer(), (AbstractPolicyRepresentation)rep);
        associatedPolicy.setOwner(owner);
        policy.addAssociatedPolicy(associatedPolicy);
    }

    private void createGroupPolicy(Policy policy, PolicyStore policyStore, String group, String owner) {
        GroupPolicyRepresentation rep = new GroupPolicyRepresentation();
        rep.setName(KeycloakModelUtils.generateId());
        rep.addGroupPath(new String[]{group});
        Policy associatedPolicy = policyStore.create(policy.getResourceServer(), (AbstractPolicyRepresentation)rep);
        associatedPolicy.setOwner(owner);
        policy.addAssociatedPolicy(associatedPolicy);
    }

    private void createRolePolicy(Policy policy, PolicyStore policyStore, String role, String owner) {
        RolePolicyRepresentation rep = new RolePolicyRepresentation();
        rep.setName(KeycloakModelUtils.generateId());
        rep.addRole(role, false);
        Policy associatedPolicy = policyStore.create(policy.getResourceServer(), (AbstractPolicyRepresentation)rep);
        associatedPolicy.setOwner(owner);
        policy.addAssociatedPolicy(associatedPolicy);
    }

    private void createUserPolicy(Policy policy, PolicyStore policyStore, String user, String owner) {
        UserPolicyRepresentation rep = new UserPolicyRepresentation();
        rep.setName(KeycloakModelUtils.generateId());
        rep.addUser(user);
        Policy associatedPolicy = policyStore.create(policy.getResourceServer(), (AbstractPolicyRepresentation)rep);
        associatedPolicy.setOwner(owner);
        policy.addAssociatedPolicy(associatedPolicy);
    }
}

