/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.permission;

import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.DefaultEvaluation;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.provider.PolicyProvider;

public abstract class AbstractPermissionProvider
implements PolicyProvider {
    private static final Logger logger = Logger.getLogger(AbstractPermissionProvider.class);

    public void evaluate(Evaluation evaluation) {
        AuthorizationProvider authorization = evaluation.getAuthorizationProvider();
        DefaultEvaluation defaultEvaluation = (DefaultEvaluation)DefaultEvaluation.class.cast(evaluation);
        Map decisionCache = defaultEvaluation.getDecisionCache();
        Policy policy = evaluation.getPolicy();
        ResourcePermission permission = evaluation.getPermission();
        for (Policy associatedPolicy : policy.getAssociatedPolicies()) {
            Map decisions = decisionCache.computeIfAbsent(associatedPolicy, p -> new HashMap());
            Decision.Effect effect = (Decision.Effect)decisions.get(permission);
            defaultEvaluation.setPolicy(associatedPolicy);
            if (effect == null) {
                PolicyProvider policyProvider = authorization.getProvider(associatedPolicy.getType());
                if (policyProvider == null) {
                    throw new RuntimeException("No policy provider found for policy [" + associatedPolicy.getType() + "]");
                }
                policyProvider.evaluate((Evaluation)defaultEvaluation);
                evaluation.denyIfNoEffect();
                decisions.put(permission, defaultEvaluation.getEffect());
                continue;
            }
            defaultEvaluation.setEffect(effect);
        }
        logger.debugv("Policy {} was evaluated with status {} in {} mode after processing {} associated policies: {}", new Object[]{policy.getName(), evaluation.getEffect(), policy.getDecisionStrategy(), policy.getAssociatedPolicies().size(), policy.getAssociatedPolicies()});
    }

    public void close() {
    }
}

