/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.commands;

import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.keycloak.client.cli.common.AttributeOperation;
import org.keycloak.client.cli.config.ConfigData;
import org.keycloak.client.cli.util.ConfigUtil;
import org.keycloak.client.cli.util.HttpUtil;
import org.keycloak.client.cli.util.IoUtil;
import org.keycloak.client.cli.util.OsUtil;
import org.keycloak.client.cli.util.ParseUtil;
import org.keycloak.client.registration.cli.CmdStdinContext;
import org.keycloak.client.registration.cli.EndpointType;
import org.keycloak.client.registration.cli.EndpointTypeConverter;
import org.keycloak.client.registration.cli.KcRegMain;
import org.keycloak.client.registration.cli.commands.AbstractAuthOptionsCmd;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.util.JsonSerialization;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"[ARGUMENTS]"})
public class CreateCmd
extends AbstractAuthOptionsCmd {
    @CommandLine.Option(names={"-i", "--clientId"}, description={"After creation only print clientId to standard output"})
    protected boolean returnClientId = false;
    @CommandLine.Option(names={"-e", "--endpoint"}, description={"Endpoint type / document format to use - one of: 'default', 'oidc', 'saml2'"}, converter={EndpointTypeConverter.class})
    protected EndpointType regType;
    @CommandLine.Option(names={"-f", "--file"}, description={"Read object from file or standard input if FILENAME is set to '-'"})
    protected String file;
    @CommandLine.Option(names={"-o", "--output"}, description={"After creation output the new client configuration to standard output"})
    protected boolean outputClient = false;
    @CommandLine.Option(names={"-c", "--compressed"}, description={"Don't pretty print the output"})
    protected boolean compressed = false;
    @CommandLine.Option(names={"-s", "--set"}, description={"Set a specific attribute NAME to a specified value VALUE"})
    List<String> rawSets = new ArrayList<String>();
    List<AttributeOperation> attrs = new ArrayList<AttributeOperation>();

    @Override
    protected void processOptions() {
        super.processOptions();
        for (String set : this.rawSets) {
            String[] keyVal = ParseUtil.parseKeyVal(set);
            this.attrs.add(new AttributeOperation(AttributeOperation.Type.SET, keyVal[0], keyVal[1]));
        }
    }

    @Override
    protected void process() {
        if (this.file == null && this.attrs.size() == 0) {
            throw new IllegalArgumentException("No file nor attribute values specified");
        }
        if (this.outputClient && this.returnClientId) {
            throw new IllegalArgumentException("Options -o and -i are mutually exclusive");
        }
        if ("-".equals(this.externalToken)) {
            this.externalToken = IoUtil.readSecret("Enter Initial Access Token: ");
        }
        CmdStdinContext ctx = new CmdStdinContext();
        if (this.file != null) {
            ctx = CmdStdinContext.parseFileOrStdin(this.file, this.regType);
        }
        if (ctx.getEndpointType() == null) {
            this.regType = this.regType != null ? this.regType : EndpointType.DEFAULT;
            ctx.setEndpointType(this.regType);
        } else if (this.regType != null && ctx.getEndpointType() != this.regType) {
            throw new RuntimeException("Requested endpoint type not compatible with detected configuration format: " + (Object)((Object)ctx.getEndpointType()));
        }
        if (this.attrs.size() > 0) {
            ctx = CmdStdinContext.mergeAttributes(ctx, this.attrs);
        }
        String contentType = EndpointType.getExpectedContentType(ctx.getEndpointType());
        ConfigData config = ConfigUtil.loadConfig();
        config = this.copyWithServerInfo(config);
        if (this.externalToken == null) {
            this.externalToken = config.sessionRealmConfigData().getInitialToken();
        }
        this.setupTruststore(config);
        String auth = this.externalToken;
        if (auth == null) {
            config = this.ensureAuthInfo(config);
            if (ConfigUtil.credentialsAvailable(config = this.copyWithServerInfo(config))) {
                auth = this.ensureToken(config);
            }
        }
        auth = auth != null ? "Bearer " + auth : null;
        String server = config.getServerUrl();
        String realm = config.getRealm();
        InputStream response = HttpUtil.doPost(server + "/realms/" + realm + "/clients-registrations/" + ctx.getEndpointType().getEndpoint(), contentType, "application/json", ctx.getContent(), auth);
        try {
            if (ctx.getEndpointType() == EndpointType.DEFAULT || ctx.getEndpointType() == EndpointType.SAML2) {
                ClientRepresentation client = JsonSerialization.readValue(response, ClientRepresentation.class);
                this.outputResult(client.getClientId(), client);
                ConfigUtil.saveMergeConfig(cfg -> ConfigUtil.setRegistrationToken(cfg.ensureRealmConfigData(server, realm), client.getClientId(), client.getRegistrationAccessToken()));
            } else if (ctx.getEndpointType() == EndpointType.OIDC) {
                OIDCClientRepresentation client = JsonSerialization.readValue(response, OIDCClientRepresentation.class);
                this.outputResult(client.getClientId(), client);
                ConfigUtil.saveMergeConfig(cfg -> ConfigUtil.setRegistrationToken(cfg.ensureRealmConfigData(server, realm), client.getClientId(), client.getRegistrationAccessToken()));
            } else {
                IoUtil.printOut("Response from server: " + IoUtil.readFully(response));
            }
        }
        catch (UnrecognizedPropertyException e) {
            throw new RuntimeException("Failed to process HTTP response - " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to process HTTP response", e);
        }
    }

    private void outputResult(String clientId, Object result) throws IOException {
        if (this.returnClientId) {
            IoUtil.printOut(clientId);
        } else if (this.outputClient) {
            if (this.compressed) {
                IoUtil.printOut(JsonSerialization.writeValueAsString(result));
            } else {
                IoUtil.printOut(JsonSerialization.writeValueAsPrettyString(result));
            }
        } else {
            IoUtil.printErr("Registered new client with client_id '" + clientId + "'");
        }
    }

    @Override
    protected boolean nothingToDo() {
        return super.nothingToDo() && this.regType == null && this.file == null && this.rawSets.isEmpty();
    }

    @Override
    protected String help() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + KcRegMain.CMD + " create [ARGUMENTS]");
        out.println();
        out.println("Command to create new client configurations on the server. If Initial Access Token is specified (-t TOKEN)");
        out.println("or has previously been set for the server, and realm in the configuration ('" + KcRegMain.CMD + " config initial-token'),");
        out.println("then that will be used, otherwise session access / refresh tokens will be used.");
        this.globalOptions(out);
        out.println("    -t, --token TOKEN     Use the specified Initial Access Token for authorization or read it from standard input ");
        out.println("                          if '-' is specified. This overrides any token set by '" + KcRegMain.CMD + " config initial-token'.");
        out.println("                          If not specified, session credentials are used - see: CREDENTIALS OPTIONS.");
        out.println("    -e, --endpoint TYPE   Endpoint type / document format to use - one of: 'default', 'oidc', 'saml2'.");
        out.println("                          If not specified, the format is deduced from input file or falls back to 'default'.");
        out.println("    -s, --set NAME=VALUE  Set a specific attribute NAME to a specified value VALUE");
        out.println("    -f, --file FILENAME   Read object from file or standard input if FILENAME is set to '-'");
        out.println("    -o, --output          After creation output the new client configuration to standard output");
        out.println("    -c, --compressed      Don't pretty print the output");
        out.println("    -i, --clientId        After creation only print clientId to standard output");
        out.println();
        out.println("Examples:");
        out.println();
        out.println("Create a new client using configuration read from standard input:");
        if (OsUtil.OS_ARCH.isWindows()) {
            out.println("  " + OsUtil.PROMPT + " echo { \"clientId\": \"my_client\" } | " + KcRegMain.CMD + " create -f -");
        } else {
            out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " create -f - << EOF");
            out.println("  {");
            out.println("    \"clientId\": \"my_client\"");
            out.println("  }");
            out.println("  EOF");
        }
        out.println();
        out.println("Since we didn't specify an endpoint type it will be deduced from configuration format.");
        out.println("Supported formats include Keycloak default format, OIDC format, and SAML SP Metadata.");
        out.println();
        out.println("Creating a client using file as a template, and overriding some attributes:");
        out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " create -f my_client.json -s clientId=my_client2 -s 'redirectUris=[\"http://localhost:8980/myapp/*\"]'");
        out.println();
        out.println("Creating a client using an Initial Access Token - you'll be prompted for a token:");
        out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " create -s clientId=my_client2 -s 'redirectUris=[\"http://localhost:8980/myapp/*\"]' -t -");
        out.println();
        out.println("Creating a client using 'oidc' endpoint. Without setting endpoint type here it would be 'default':");
        out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " create -e oidc -s 'redirect_uris=[\"http://localhost:8980/myapp/*\"]'");
        out.println();
        out.println("Creating a client using 'saml2' endpoint. In this case setting endpoint type is redundant since it is deduced ");
        out.println("from file content:");
        out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " create -e saml2 -f saml-sp-metadata.xml");
        out.println();
        out.println();
        out.println("Use '" + KcRegMain.CMD + " help' for general information and a list of commands");
        return sb.toString();
    }
}

