/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.jaxrs;

import jakarta.ws.rs.sse.OutboundSseEvent;
import jakarta.ws.rs.sse.SseBroadcaster;
import jakarta.ws.rs.sse.SseEventSink;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jboss.resteasy.reactive.server.jaxrs.SseEventSinkImpl;

public class SseBroadcasterImpl
implements SseBroadcaster {
    private final List<SseEventSink> sinks = new ArrayList<SseEventSink>();
    private final List<BiConsumer<SseEventSink, Throwable>> onErrorListeners = new ArrayList<BiConsumer<SseEventSink, Throwable>>();
    private final List<Consumer<SseEventSink>> onCloseListeners = new ArrayList<Consumer<SseEventSink>>();
    private volatile boolean isClosed;

    public synchronized void onError(BiConsumer<SseEventSink, Throwable> onError) {
        Objects.requireNonNull(onError);
        this.checkClosed();
        this.onErrorListeners.add(onError);
    }

    public synchronized void onClose(Consumer<SseEventSink> onClose) {
        Objects.requireNonNull(onClose);
        this.checkClosed();
        this.onCloseListeners.add(onClose);
    }

    public synchronized void register(SseEventSink sseEventSink) {
        Objects.requireNonNull(sseEventSink);
        this.checkClosed();
        if (!(sseEventSink instanceof SseEventSinkImpl)) {
            throw new IllegalArgumentException("Can only work with Quarkus-REST instances: " + sseEventSink);
        }
        ((SseEventSinkImpl)sseEventSink).register(this);
        this.sinks.add(sseEventSink);
    }

    public synchronized CompletionStage<?> broadcast(OutboundSseEvent event) {
        Objects.requireNonNull(event);
        this.checkClosed();
        CompletableFuture[] cfs = new CompletableFuture[this.sinks.size()];
        for (int i = 0; i < this.sinks.size(); ++i) {
            CompletionStage<Object> cs;
            SseEventSink sseEventSink = this.sinks.get(i);
            try {
                cs = sseEventSink.send(event).exceptionally(t -> {
                    this.notifyOnErrorListeners(sseEventSink, (Throwable)t);
                    return null;
                });
            }
            catch (Exception e) {
                this.notifyOnErrorListeners(sseEventSink, e);
                cs = CompletableFuture.completedFuture(null);
            }
            cfs[i] = cs.toCompletableFuture();
        }
        return CompletableFuture.allOf(cfs);
    }

    private void notifyOnErrorListeners(SseEventSink eventSink, Throwable throwable) {
        if (throwable instanceof IOException || throwable instanceof IllegalStateException) {
            this.notifyOnCloseListeners(eventSink);
        }
        this.onErrorListeners.forEach(consumer -> consumer.accept(eventSink, throwable));
    }

    private void notifyOnCloseListeners(SseEventSink eventSink) {
        if (this.sinks.remove(eventSink)) {
            this.onCloseListeners.forEach(consumer -> consumer.accept(eventSink));
        }
    }

    private void checkClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("Broadcaster has been closed");
        }
    }

    public synchronized void close() {
        this.close(true);
    }

    public synchronized void close(boolean cascading) {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (cascading) {
            for (SseEventSink sink : this.sinks) {
                sink.close();
            }
        }
    }

    synchronized void fireClose(SseEventSinkImpl sseEventSink) {
        for (Consumer<SseEventSink> listener : this.onCloseListeners) {
            listener.accept(sseEventSink);
        }
        if (!this.isClosed) {
            this.sinks.remove(sseEventSink);
        }
    }
}

