/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.future;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.FutureBase;
import io.vertx.core.impl.future.Listener;
import java.util.Objects;
import java.util.function.Function;

public final class SucceededFuture<T>
extends FutureBase<T> {
    public static final SucceededFuture EMPTY = new SucceededFuture<Object>(null, null);
    private final T result;

    public SucceededFuture(T result) {
        this(null, result);
    }

    public SucceededFuture(ContextInternal context, T result) {
        super(context);
        this.result = result;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public Future<T> onSuccess(Handler<T> handler) {
        if (this.context != null) {
            this.context.emit(this.result, handler);
        } else {
            handler.handle(this.result);
        }
        return this;
    }

    @Override
    public Future<T> onFailure(Handler<Throwable> handler) {
        return this;
    }

    @Override
    public Future<T> onComplete(Handler<AsyncResult<T>> handler) {
        if (handler instanceof Listener) {
            this.emitSuccess(this.result, (Listener)((Object)handler));
        } else if (this.context != null) {
            this.context.emit(this, handler);
        } else {
            handler.handle(this);
        }
        return this;
    }

    @Override
    public void addListener(Listener<T> listener) {
        this.emitSuccess(this.result, listener);
    }

    @Override
    public void removeListener(Listener<T> listener) {
    }

    @Override
    public T result() {
        return this.result;
    }

    @Override
    public Throwable cause() {
        return null;
    }

    @Override
    public boolean succeeded() {
        return true;
    }

    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public <V> Future<V> map(V value) {
        return new SucceededFuture<V>(this.context, value);
    }

    @Override
    public Future<T> otherwise(Function<Throwable, T> mapper) {
        Objects.requireNonNull(mapper, "No null mapper accepted");
        return this;
    }

    @Override
    public Future<T> otherwise(T value) {
        return this;
    }

    public String toString() {
        return "Future{result=" + this.result + "}";
    }
}

