/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.oauth2;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.mechanism.oauth2.OAuth2Client;
import org.wildfly.security.sasl.oauth2.OAuth2SaslClient;

public final class OAuth2SaslClientFactory
implements SaslClientFactory {
    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        if (this.getMechanismNames(props, false).length == 0) {
            return null;
        }
        for (String mechanism : mechanisms) {
            if (!"OAUTHBEARER".equals(mechanism)) continue;
            return new OAuth2SaslClient(mechanism, protocol, serverName, cbh, authorizationId, new OAuth2Client(authorizationId, cbh, ElytronMessages.saslOAuth2));
        }
        return null;
    }

    private String[] getMechanismNames(Map<String, ?> props, boolean query) {
        if (props == null) {
            return new String[]{"OAUTHBEARER"};
        }
        if ("true".equals(props.get("wildfly.sasl.mechanism-query-all")) && query) {
            return new String[]{"OAUTHBEARER"};
        }
        if ("true".equals(props.get("javax.security.sasl.policy.noplaintext")) || "true".equals(props.get("javax.security.sasl.policy.noactive")) || "true".equals(props.get("javax.security.sasl.policy.nodictionary"))) {
            return new String[0];
        }
        return new String[]{"OAUTHBEARER"};
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return this.getMechanismNames(props, true);
    }
}

