/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jboss.jandex.DotName;
import org.jboss.jandex.PrimitiveType;

public abstract class Type {
    public static VoidType voidType() {
        return VoidType.INSTANCE;
    }

    public static PrimitiveType booleanType() {
        return PrimitiveType.BOOLEAN;
    }

    public static PrimitiveType byteType() {
        return PrimitiveType.BYTE;
    }

    public static PrimitiveType shortType() {
        return PrimitiveType.SHORT;
    }

    public static PrimitiveType intType() {
        return PrimitiveType.INT;
    }

    public static PrimitiveType longType() {
        return PrimitiveType.LONG;
    }

    public static PrimitiveType floatType() {
        return PrimitiveType.FLOAT;
    }

    public static PrimitiveType doubleType() {
        return PrimitiveType.DOUBLE;
    }

    public static PrimitiveType charType() {
        return PrimitiveType.CHAR;
    }

    public static ClassType classType(DotName className) {
        return Type.classType(className.toString());
    }

    public static ClassType classType(String className) {
        return new ClassType(className.replace('.', '/'), null);
    }

    public static ClassType classType(Class<?> clazz) {
        return Type.classType(clazz.getName());
    }

    public static ParameterizedType parameterizedType(ClassType genericClass, Type ... typeArguments) {
        if (typeArguments.length == 0) {
            throw new IllegalArgumentException("No type arguments");
        }
        return new ParameterizedType(genericClass, Arrays.asList(typeArguments), null);
    }

    public static ArrayType arrayType(Type elementType) {
        return new ArrayType(elementType, 1);
    }

    public static ArrayType arrayType(Type elementType, int dimensions) {
        return new ArrayType(elementType, dimensions);
    }

    public static TypeVariable typeVariable(String name) {
        return Type.typeVariable(name, ClassType.OBJECT);
    }

    public static TypeVariable typeVariable(String name, Type classOrTypeVariableBound) {
        Type bound = Objects.requireNonNull(classOrTypeVariableBound);
        if (!(bound.isClass() || bound.isParameterizedType() || bound.isTypeVariable())) {
            throw new IllegalArgumentException("Type variable bound must be a class or a type variable");
        }
        return new TypeVariable(name, bound, Collections.emptyList());
    }

    public static TypeVariable typeVariable(String name, Type classBound, Type ... interfaceBounds) {
        if (classBound != null && !classBound.isClass() && !classBound.isParameterizedType()) {
            throw new IllegalArgumentException("First type variable bound must be a class");
        }
        for (Type interfaceBound : interfaceBounds) {
            if (interfaceBound.isClass() || interfaceBound.isParameterizedType()) continue;
            throw new IllegalArgumentException("Next type variable bounds must all be interfaces");
        }
        return new TypeVariable(name, classBound, Arrays.asList(interfaceBounds));
    }

    public static WildcardType wildcardTypeWithUpperBound(Type bound) {
        return new WildcardType(Objects.requireNonNull(bound), null);
    }

    public static WildcardType wildcardTypeWithLowerBound(Type bound) {
        return new WildcardType(null, Objects.requireNonNull(bound));
    }

    public static WildcardType wildcardTypeUnbounded() {
        return new WildcardType(ClassType.OBJECT, null);
    }

    abstract void appendToSignature(StringBuilder var1);

    boolean isVoid() {
        return false;
    }

    boolean isPrimitive() {
        return false;
    }

    boolean isClass() {
        return false;
    }

    boolean isArray() {
        return false;
    }

    boolean isParameterizedType() {
        return false;
    }

    boolean isTypeVariable() {
        return false;
    }

    boolean isWildcard() {
        return false;
    }

    VoidType asVoid() {
        throw new IllegalStateException("Not a void");
    }

    PrimitiveType asPrimitive() {
        throw new IllegalStateException("Not a primitive");
    }

    ClassType asClass() {
        throw new IllegalStateException("Not a class");
    }

    ArrayType asArray() {
        throw new IllegalStateException("Not an array");
    }

    ParameterizedType asParameterizedType() {
        throw new IllegalStateException("Not a parameterized type");
    }

    TypeVariable asTypeVariable() {
        throw new IllegalStateException("Not a type variable");
    }

    WildcardType asWildcard() {
        throw new IllegalStateException("Not a wildcard type");
    }

    public static final class WildcardType
    extends Type {
        private final Type upperBound;
        private final Type lowerBound;

        WildcardType(Type upperBound, Type lowerBound) {
            if (upperBound == null && lowerBound == null) {
                throw new NullPointerException();
            }
            if (upperBound != null && lowerBound != null) {
                throw new IllegalArgumentException();
            }
            this.upperBound = upperBound;
            this.lowerBound = lowerBound;
        }

        @Override
        boolean isWildcard() {
            return true;
        }

        @Override
        WildcardType asWildcard() {
            return this;
        }

        @Override
        void appendToSignature(StringBuilder signature) {
            if (this.lowerBound != null) {
                signature.append('-');
                this.lowerBound.appendToSignature(signature);
            } else if (this.upperBound.isClass() && this.upperBound.asClass().name.equals(ClassType.OBJECT.name)) {
                signature.append('*');
            } else {
                signature.append('+');
                this.upperBound.appendToSignature(signature);
            }
        }
    }

    public static final class TypeVariable
    extends Type {
        private final String name;
        private final Type firstBound;
        private final List<Type> nextBounds;

        TypeVariable(String name, Type firstBound, List<Type> nextBounds) {
            this.name = Objects.requireNonNull(name);
            this.firstBound = firstBound;
            this.nextBounds = Objects.requireNonNull(nextBounds);
        }

        @Override
        void appendToSignature(StringBuilder signature) {
            signature.append('T').append(this.name).append(';');
        }

        void appendTypeParameterToSignature(StringBuilder signature) {
            signature.append(this.name).append(":");
            if (this.firstBound != null) {
                this.firstBound.appendToSignature(signature);
            }
            for (Type bound : this.nextBounds) {
                signature.append(":");
                bound.appendToSignature(signature);
            }
        }

        @Override
        boolean isTypeVariable() {
            return true;
        }

        @Override
        TypeVariable asTypeVariable() {
            return this;
        }
    }

    public static final class ParameterizedType
    extends Type {
        final ClassType genericClass;
        final List<Type> typeArguments;
        final Type owner;

        ParameterizedType(ClassType genericClass, List<Type> typeArguments, Type owner) {
            this.genericClass = Objects.requireNonNull(genericClass);
            this.typeArguments = Objects.requireNonNull(typeArguments);
            this.owner = owner;
        }

        public ClassType innerClass(String simpleName) {
            return new ClassType(simpleName, this);
        }

        public ParameterizedType innerParameterizedType(String simpleName, Type ... typeArguments) {
            return new ParameterizedType(new ClassType(simpleName, null), Arrays.asList(typeArguments), this);
        }

        @Override
        void appendToSignature(StringBuilder signature) {
            if (this.owner != null) {
                this.owner.appendToSignature(signature);
                signature.setCharAt(signature.length() - 1, '.');
            } else {
                signature.append('L');
            }
            signature.append(this.genericClass.name);
            if (!this.typeArguments.isEmpty()) {
                signature.append('<');
                for (Type typeArgument : this.typeArguments) {
                    typeArgument.appendToSignature(signature);
                }
                signature.append('>');
            }
            signature.append(';');
        }

        @Override
        boolean isParameterizedType() {
            return true;
        }

        @Override
        ParameterizedType asParameterizedType() {
            return this;
        }

        List<Type> getTypeArguments() {
            return Collections.unmodifiableList(this.typeArguments);
        }
    }

    public static final class ArrayType
    extends Type {
        private final Type elementType;
        private final int dimensions;

        ArrayType(Type elementType, int dimensions) {
            this.elementType = Objects.requireNonNull(elementType);
            this.dimensions = dimensions;
        }

        @Override
        void appendToSignature(StringBuilder signature) {
            for (int i = 0; i < this.dimensions; ++i) {
                signature.append('[');
            }
            this.elementType.appendToSignature(signature);
        }

        @Override
        boolean isArray() {
            return true;
        }

        @Override
        ArrayType asArray() {
            return this;
        }
    }

    public static final class ClassType
    extends Type {
        public static final ClassType OBJECT = new ClassType("java/lang/Object", null);
        final String name;
        final Type owner;

        ClassType(String name, Type owner) {
            this.name = Objects.requireNonNull(name);
            this.owner = owner;
        }

        public ClassType innerClass(String simpleName) {
            return new ClassType(simpleName, this);
        }

        public ParameterizedType innerParameterizedType(String simpleName, Type ... typeArguments) {
            return new ParameterizedType(new ClassType(simpleName, null), Arrays.asList(typeArguments), this);
        }

        @Override
        void appendToSignature(StringBuilder signature) {
            if (this.owner != null) {
                this.owner.appendToSignature(signature);
                signature.setCharAt(signature.length() - 1, '.');
            } else {
                signature.append('L');
            }
            signature.append(this.name).append(';');
        }

        @Override
        boolean isClass() {
            return true;
        }

        @Override
        ClassType asClass() {
            return this;
        }
    }

    public static final class PrimitiveType
    extends Type {
        public static final PrimitiveType BOOLEAN = new PrimitiveType(PrimitiveType.Primitive.BOOLEAN);
        public static final PrimitiveType BYTE = new PrimitiveType(PrimitiveType.Primitive.BYTE);
        public static final PrimitiveType SHORT = new PrimitiveType(PrimitiveType.Primitive.SHORT);
        public static final PrimitiveType INT = new PrimitiveType(PrimitiveType.Primitive.INT);
        public static final PrimitiveType LONG = new PrimitiveType(PrimitiveType.Primitive.LONG);
        public static final PrimitiveType FLOAT = new PrimitiveType(PrimitiveType.Primitive.FLOAT);
        public static final PrimitiveType DOUBLE = new PrimitiveType(PrimitiveType.Primitive.DOUBLE);
        public static final PrimitiveType CHAR = new PrimitiveType(PrimitiveType.Primitive.CHAR);
        private final PrimitiveType.Primitive primitive;

        PrimitiveType(PrimitiveType.Primitive primitive) {
            this.primitive = Objects.requireNonNull(primitive);
        }

        @Override
        void appendToSignature(StringBuilder signature) {
            switch (this.primitive) {
                case BOOLEAN: {
                    signature.append("Z");
                    break;
                }
                case BYTE: {
                    signature.append("B");
                    break;
                }
                case SHORT: {
                    signature.append("S");
                }
                case INT: {
                    signature.append("I");
                    break;
                }
                case LONG: {
                    signature.append("J");
                    break;
                }
                case FLOAT: {
                    signature.append("F");
                    break;
                }
                case DOUBLE: {
                    signature.append("D");
                    break;
                }
                case CHAR: {
                    signature.append("C");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown primitive type: " + this.primitive.toString());
                }
            }
        }

        @Override
        boolean isPrimitive() {
            return true;
        }

        @Override
        PrimitiveType asPrimitive() {
            return this;
        }
    }

    public static final class VoidType
    extends Type {
        public static final VoidType INSTANCE = new VoidType();

        @Override
        void appendToSignature(StringBuilder signature) {
            signature.append("V");
        }

        @Override
        boolean isVoid() {
            return true;
        }

        @Override
        VoidType asVoid() {
            return this;
        }
    }
}

