/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.entities;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

@SerializeWith(value=ExternalizerImpl.class)
public class LoginFailureEntity
extends SessionEntity {
    private String userId;
    private int failedLoginNotBefore;
    private int numFailures;
    private int numTemporaryLockouts;
    private long lastFailure;
    private String lastIPFailure;

    public LoginFailureEntity() {
    }

    private LoginFailureEntity(String realmId, String userId, int failedLoginNotBefore, int numFailures, int numTemporaryLockouts, long lastFailure, String lastIPFailure) {
        super(realmId);
        this.userId = userId;
        this.failedLoginNotBefore = failedLoginNotBefore;
        this.numFailures = numFailures;
        this.numTemporaryLockouts = numTemporaryLockouts;
        this.lastFailure = lastFailure;
        this.lastIPFailure = lastIPFailure;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public int getFailedLoginNotBefore() {
        return this.failedLoginNotBefore;
    }

    public void setFailedLoginNotBefore(int failedLoginNotBefore) {
        if (failedLoginNotBefore > this.failedLoginNotBefore) {
            this.failedLoginNotBefore = failedLoginNotBefore;
        }
    }

    public int getNumFailures() {
        return this.numFailures;
    }

    public void setNumFailures(int numFailures) {
        this.numFailures = numFailures;
    }

    public int getNumTemporaryLockouts() {
        return this.numTemporaryLockouts;
    }

    public void setNumTemporaryLockouts(int numTemporaryLockouts) {
        this.numTemporaryLockouts = numTemporaryLockouts;
    }

    public long getLastFailure() {
        return this.lastFailure;
    }

    public void setLastFailure(long lastFailure) {
        if (lastFailure > this.lastFailure) {
            this.lastFailure = lastFailure;
        }
    }

    public String getLastIPFailure() {
        return this.lastIPFailure;
    }

    public void setLastIPFailure(String lastIPFailure) {
        this.lastIPFailure = lastIPFailure;
    }

    public void clearFailures() {
        this.failedLoginNotBefore = 0;
        this.numFailures = 0;
        this.numTemporaryLockouts = 0;
        this.lastFailure = 0L;
        this.lastIPFailure = null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoginFailureEntity)) {
            return false;
        }
        LoginFailureEntity that = (LoginFailureEntity)o;
        if (this.userId != null ? !this.userId.equals(that.userId) : that.userId != null) {
            return false;
        }
        return !(this.getRealmId() != null ? !this.getRealmId().equals(that.getRealmId()) : that.getRealmId() != null);
    }

    @Override
    public int hashCode() {
        int hashCode = this.getRealmId() != null ? this.getRealmId().hashCode() : 0;
        hashCode = hashCode * 13 + (this.userId != null ? this.userId.hashCode() : 0);
        return hashCode;
    }

    public String toString() {
        return String.format("LoginFailureEntity [ userId=%s, realm=%s, numFailures=%d ]", this.userId, this.getRealmId(), this.numFailures);
    }

    public static class ExternalizerImpl
    implements Externalizer<LoginFailureEntity> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, LoginFailureEntity value) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)value.getRealmId(), (ObjectOutput)output);
            MarshallUtil.marshallString((String)value.userId, (ObjectOutput)output);
            output.writeInt(value.failedLoginNotBefore);
            output.writeInt(value.numFailures);
            output.writeInt(value.numTemporaryLockouts);
            output.writeLong(value.lastFailure);
            MarshallUtil.marshallString((String)value.lastIPFailure, (ObjectOutput)output);
        }

        public LoginFailureEntity readObject(ObjectInput input) throws IOException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public LoginFailureEntity readObjectVersion1(ObjectInput input) throws IOException {
            return new LoginFailureEntity(MarshallUtil.unmarshallString((ObjectInput)input), MarshallUtil.unmarshallString((ObjectInput)input), input.readInt(), input.readInt(), input.readInt(), input.readLong(), MarshallUtil.unmarshallString((ObjectInput)input));
        }
    }
}

