/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.definition;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.components.ComponentsWriter;
import io.smallrye.openapi.runtime.io.extension.ExtensionWriter;
import io.smallrye.openapi.runtime.io.externaldocs.ExternalDocsWriter;
import io.smallrye.openapi.runtime.io.info.InfoWriter;
import io.smallrye.openapi.runtime.io.paths.PathsWriter;
import io.smallrye.openapi.runtime.io.securityrequirement.SecurityRequirementWriter;
import io.smallrye.openapi.runtime.io.server.ServerWriter;
import io.smallrye.openapi.runtime.io.tag.TagWriter;
import org.eclipse.microprofile.openapi.models.OpenAPI;

public class DefinitionWriter {
    private DefinitionWriter() {
    }

    public static void writeOpenAPI(ObjectNode node, OpenAPI model) {
        JsonUtil.stringProperty(node, "openapi", model.getOpenapi());
        InfoWriter.writeInfo(node, model.getInfo());
        ExternalDocsWriter.writeExternalDocumentation(node, model.getExternalDocs());
        ServerWriter.writeServers(node, model.getServers());
        SecurityRequirementWriter.writeSecurityRequirements(node, model.getSecurity());
        TagWriter.writeTags(node, model.getTags());
        PathsWriter.writePaths(node, model.getPaths());
        ComponentsWriter.writeComponents(node, model.getComponents());
        ExtensionWriter.writeExtensions(node, model);
    }
}

