/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.jandex.TypeVariableReference;
import org.jboss.jandex.UnresolvedTypeVariable;
import org.jboss.jandex.WildcardType;
import org.objectweb.asm.MethodVisitor;

public class AsmUtil {
    public static final List<org.objectweb.asm.Type> PRIMITIVES = Arrays.asList(org.objectweb.asm.Type.VOID_TYPE, org.objectweb.asm.Type.BOOLEAN_TYPE, org.objectweb.asm.Type.CHAR_TYPE, org.objectweb.asm.Type.BYTE_TYPE, org.objectweb.asm.Type.SHORT_TYPE, org.objectweb.asm.Type.INT_TYPE, org.objectweb.asm.Type.FLOAT_TYPE, org.objectweb.asm.Type.LONG_TYPE, org.objectweb.asm.Type.DOUBLE_TYPE);
    public static final List<org.objectweb.asm.Type> WRAPPERS = Arrays.asList(org.objectweb.asm.Type.getType(Void.class), org.objectweb.asm.Type.getType(Boolean.class), org.objectweb.asm.Type.getType(Character.class), org.objectweb.asm.Type.getType(Byte.class), org.objectweb.asm.Type.getType(Short.class), org.objectweb.asm.Type.getType(Integer.class), org.objectweb.asm.Type.getType(Float.class), org.objectweb.asm.Type.getType(Long.class), org.objectweb.asm.Type.getType(Double.class));
    public static final Map<org.objectweb.asm.Type, org.objectweb.asm.Type> WRAPPER_TO_PRIMITIVE = new HashMap<org.objectweb.asm.Type, org.objectweb.asm.Type>();
    public static final Map<Character, String> PRIMITIVE_DESCRIPTOR_TO_PRIMITIVE_CLASS_LITERAL;

    public static org.objectweb.asm.Type autobox(org.objectweb.asm.Type primitive) {
        return WRAPPERS.get(primitive.getSort());
    }

    @Deprecated(since="3.1", forRemoval=true)
    public static String getSignatureIfRequired(MethodInfo method) {
        return method.genericSignatureIfRequired();
    }

    @Deprecated(since="3.1", forRemoval=true)
    public static String getSignatureIfRequired(MethodInfo method, Function<String, String> typeArgMapper) {
        if (!method.requiresGenericSignature()) {
            return null;
        }
        return AsmUtil.getSignature(method, typeArgMapper);
    }

    private static boolean hasThrowsSignature(MethodInfo method) {
        for (Type type : method.exceptions()) {
            if (type.kind() != Type.Kind.TYPE_VARIABLE && type.kind() != Type.Kind.UNRESOLVED_TYPE_VARIABLE) continue;
            return true;
        }
        return false;
    }

    @Deprecated(since="3.1", forRemoval=true)
    public static String getSignature(MethodInfo method, Function<String, String> typeArgMapper) {
        StringBuilder signature = new StringBuilder();
        if (!method.typeParameters().isEmpty()) {
            signature.append('<');
            for (TypeVariable typeParameter : method.typeParameters()) {
                AsmUtil.typeParameter(typeParameter, signature, typeArgMapper);
            }
            signature.append('>');
        }
        signature.append('(');
        for (Type type : method.parameterTypes()) {
            AsmUtil.toSignature(signature, type, typeArgMapper, false);
        }
        signature.append(')');
        AsmUtil.toSignature(signature, method.returnType(), typeArgMapper, false);
        if (AsmUtil.hasThrowsSignature(method)) {
            for (Type exception : method.exceptions()) {
                signature.append('^');
                AsmUtil.toSignature(signature, exception, typeArgMapper, false);
            }
        }
        return signature.toString();
    }

    private static void typeParameter(TypeVariable typeParameter, StringBuilder result, Function<String, String> typeArgMapper) {
        result.append(typeParameter.identifier());
        if (AsmUtil.hasImplicitObjectBound(typeParameter)) {
            result.append(':');
        }
        for (Type bound : typeParameter.bounds()) {
            result.append(':');
            AsmUtil.toSignature(result, bound, typeArgMapper, false);
        }
    }

    private static boolean hasImplicitObjectBound(TypeVariable typeParameter) {
        boolean result = false;
        try {
            Method method = TypeVariable.class.getDeclaredMethod("hasImplicitObjectBound", new Class[0]);
            method.setAccessible(true);
            result = (Boolean)method.invoke((Object)typeParameter, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Deprecated(since="3.1", forRemoval=true)
    public static String getDescriptor(MethodInfo method, Function<String, String> typeArgMapper) {
        List parameters = method.parameterTypes();
        StringBuilder descriptor = new StringBuilder("(");
        for (Type type : parameters) {
            AsmUtil.toSignature(descriptor, type, typeArgMapper, true);
        }
        descriptor.append(")");
        AsmUtil.toSignature(descriptor, method.returnType(), typeArgMapper, true);
        return descriptor.toString();
    }

    @Deprecated(since="3.1", forRemoval=true)
    public static String getDescriptor(Type type, Function<String, String> typeArgMapper) {
        StringBuilder sb = new StringBuilder();
        AsmUtil.toSignature(sb, type, typeArgMapper, true);
        return sb.toString();
    }

    @Deprecated(since="3.1", forRemoval=true)
    public static String getSignature(Type type, Function<String, String> typeArgMapper) {
        StringBuilder sb = new StringBuilder();
        AsmUtil.toSignature(sb, type, typeArgMapper, false);
        return sb.toString();
    }

    private static void toSignature(StringBuilder sb, Type type, Function<String, String> typeArgMapper, boolean erased) {
        switch (type.kind()) {
            case ARRAY: {
                ArrayType arrayType = type.asArrayType();
                for (int i = 0; i < arrayType.dimensions(); ++i) {
                    sb.append('[');
                }
                AsmUtil.toSignature(sb, arrayType.constituent(), typeArgMapper, erased);
                break;
            }
            case CLASS: {
                sb.append('L').append(type.asClassType().name().toString('/')).append(';');
                break;
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedType parameterizedType = type.asParameterizedType();
                Type owner = parameterizedType.owner();
                if (owner != null && owner.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                    AsmUtil.toSignature(sb, owner, typeArgMapper, erased);
                    assert (sb.charAt(sb.length() - 1) == ';');
                    sb.setCharAt(sb.length() - 1, '.');
                    sb.append(parameterizedType.name().local());
                } else {
                    sb.append('L').append(parameterizedType.name().toString('/'));
                }
                if (!erased && !parameterizedType.arguments().isEmpty()) {
                    sb.append('<');
                    for (Type argument : parameterizedType.arguments()) {
                        AsmUtil.toSignature(sb, argument, typeArgMapper, erased);
                    }
                    sb.append('>');
                }
                sb.append(';');
                break;
            }
            case PRIMITIVE: {
                PrimitiveType.Primitive primitive = type.asPrimitiveType().primitive();
                switch (primitive) {
                    case BOOLEAN: {
                        sb.append('Z');
                        break;
                    }
                    case BYTE: {
                        sb.append('B');
                        break;
                    }
                    case CHAR: {
                        sb.append('C');
                        break;
                    }
                    case DOUBLE: {
                        sb.append('D');
                        break;
                    }
                    case FLOAT: {
                        sb.append('F');
                        break;
                    }
                    case INT: {
                        sb.append('I');
                        break;
                    }
                    case LONG: {
                        sb.append('J');
                        break;
                    }
                    case SHORT: {
                        sb.append('S');
                    }
                }
                break;
            }
            case TYPE_VARIABLE: {
                TypeVariable typeVariable = type.asTypeVariable();
                String mappedSignature = typeArgMapper.apply(typeVariable.identifier());
                if (mappedSignature != null) {
                    sb.append(mappedSignature);
                    break;
                }
                if (erased) {
                    AsmUtil.toSignature(sb, (Type)typeVariable.bounds().get(0), typeArgMapper, erased);
                    break;
                }
                sb.append('T').append(typeVariable.identifier()).append(';');
                break;
            }
            case UNRESOLVED_TYPE_VARIABLE: {
                UnresolvedTypeVariable unresolvedTypeVariable = type.asUnresolvedTypeVariable();
                String mappedSignature2 = typeArgMapper.apply(unresolvedTypeVariable.identifier());
                if (mappedSignature2 != null) {
                    sb.append(mappedSignature2);
                    break;
                }
                if (erased) break;
                sb.append("T").append(unresolvedTypeVariable.identifier()).append(";");
                break;
            }
            case TYPE_VARIABLE_REFERENCE: {
                TypeVariableReference typeVariableReference = type.asTypeVariableReference();
                String mappedSignature3 = typeArgMapper.apply(typeVariableReference.identifier());
                if (mappedSignature3 != null) {
                    sb.append(mappedSignature3);
                    break;
                }
                if (erased) break;
                sb.append("T").append(typeVariableReference.identifier()).append(";");
                break;
            }
            case VOID: {
                sb.append('V');
                break;
            }
            case WILDCARD_TYPE: {
                if (erased) break;
                WildcardType wildcardType = type.asWildcardType();
                if (wildcardType.superBound() != null) {
                    sb.append('-');
                    AsmUtil.toSignature(sb, wildcardType.superBound(), typeArgMapper, erased);
                    break;
                }
                if (ClassType.OBJECT_TYPE.equals((Object)wildcardType.extendsBound())) {
                    sb.append('*');
                    break;
                }
                sb.append('+');
                AsmUtil.toSignature(sb, wildcardType.extendsBound(), typeArgMapper, erased);
                break;
            }
        }
    }

    public static int getReturnInstruction(String typeDescriptor) {
        switch (typeDescriptor) {
            case "Z": 
            case "B": 
            case "C": 
            case "S": 
            case "I": {
                return 172;
            }
            case "J": {
                return 173;
            }
            case "F": {
                return 174;
            }
            case "D": {
                return 175;
            }
            case "V": {
                return 177;
            }
        }
        return 176;
    }

    public static int getReturnInstruction(Type jandexType) {
        if (jandexType.kind() == Type.Kind.PRIMITIVE) {
            switch (jandexType.asPrimitiveType().primitive()) {
                case BOOLEAN: 
                case BYTE: 
                case CHAR: 
                case INT: 
                case SHORT: {
                    return 172;
                }
                case DOUBLE: {
                    return 175;
                }
                case FLOAT: {
                    return 174;
                }
                case LONG: {
                    return 173;
                }
            }
            throw new IllegalArgumentException("Unknown primitive type: " + jandexType);
        }
        if (jandexType.kind() == Type.Kind.VOID) {
            return 177;
        }
        return 176;
    }

    public static void visitLdc(MethodVisitor mv, Type jandexType) {
        block0 : switch (jandexType.kind()) {
            case ARRAY: {
                mv.visitLdcInsn((Object)org.objectweb.asm.Type.getType((String)jandexType.name().toString('/').replace('.', '/')));
                break;
            }
            case CLASS: 
            case PARAMETERIZED_TYPE: {
                mv.visitLdcInsn((Object)org.objectweb.asm.Type.getType((String)("L" + jandexType.name().toString('/') + ";")));
                break;
            }
            case PRIMITIVE: {
                switch (jandexType.asPrimitiveType().primitive()) {
                    case BOOLEAN: {
                        mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                    case BYTE: {
                        mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                    case CHAR: {
                        mv.visitFieldInsn(178, "java/lang/Character", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                    case DOUBLE: {
                        mv.visitFieldInsn(178, "java/lang/Double", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                    case FLOAT: {
                        mv.visitFieldInsn(178, "java/lang/Float", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                    case INT: {
                        mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                    case LONG: {
                        mv.visitFieldInsn(178, "java/lang/Long", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                    case SHORT: {
                        mv.visitFieldInsn(178, "java/lang/Short", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Unknown primitive type: " + jandexType);
            }
            case TYPE_VARIABLE: {
                List bounds = jandexType.asTypeVariable().bounds();
                if (bounds.isEmpty()) {
                    mv.visitLdcInsn((Object)org.objectweb.asm.Type.getType(Object.class));
                    break;
                }
                AsmUtil.visitLdc(mv, (Type)bounds.get(0));
                break;
            }
            case UNRESOLVED_TYPE_VARIABLE: 
            case TYPE_VARIABLE_REFERENCE: {
                mv.visitLdcInsn((Object)org.objectweb.asm.Type.getType(Object.class));
                break;
            }
            case VOID: {
                mv.visitFieldInsn(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case WILDCARD_TYPE: {
                AsmUtil.visitLdc(mv, jandexType.asWildcardType().extendsBound());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown jandex type: " + jandexType);
            }
        }
    }

    public static void boxIfRequired(MethodVisitor mv, Type jandexType) {
        if (jandexType.kind() == Type.Kind.PRIMITIVE) {
            switch (jandexType.asPrimitiveType().primitive()) {
                case BOOLEAN: {
                    mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                    break;
                }
                case BYTE: {
                    mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                    break;
                }
                case CHAR: {
                    mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                    break;
                }
                case DOUBLE: {
                    mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                    break;
                }
                case FLOAT: {
                    mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                    break;
                }
                case INT: {
                    mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                    break;
                }
                case LONG: {
                    mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                    break;
                }
                case SHORT: {
                    mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown primitive type: " + jandexType);
                }
            }
        }
    }

    public static int getLoadOpcode(Type jandexType) {
        if (jandexType.kind() == Type.Kind.PRIMITIVE) {
            switch (jandexType.asPrimitiveType().primitive()) {
                case BOOLEAN: 
                case BYTE: 
                case CHAR: 
                case INT: 
                case SHORT: {
                    return 21;
                }
                case DOUBLE: {
                    return 24;
                }
                case FLOAT: {
                    return 23;
                }
                case LONG: {
                    return 22;
                }
            }
            throw new IllegalArgumentException("Unknown primitive type: " + jandexType);
        }
        return 25;
    }

    public static void unboxIfRequired(MethodVisitor mv, Type jandexType) {
        if (jandexType.kind() == Type.Kind.PRIMITIVE) {
            switch (jandexType.asPrimitiveType().primitive()) {
                case BOOLEAN: {
                    AsmUtil.unbox(mv, "java/lang/Boolean", "booleanValue", "Z");
                    break;
                }
                case BYTE: {
                    AsmUtil.unbox(mv, "java/lang/Byte", "byteValue", "B");
                    break;
                }
                case CHAR: {
                    AsmUtil.unbox(mv, "java/lang/Character", "charValue", "C");
                    break;
                }
                case DOUBLE: {
                    AsmUtil.unbox(mv, "java/lang/Double", "doubleValue", "D");
                    break;
                }
                case FLOAT: {
                    AsmUtil.unbox(mv, "java/lang/Float", "floatValue", "F");
                    break;
                }
                case INT: {
                    AsmUtil.unbox(mv, "java/lang/Integer", "intValue", "I");
                    break;
                }
                case LONG: {
                    AsmUtil.unbox(mv, "java/lang/Long", "longValue", "J");
                    break;
                }
                case SHORT: {
                    AsmUtil.unbox(mv, "java/lang/Short", "shortValue", "S");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown primitive type: " + jandexType);
                }
            }
        }
    }

    public static void unboxIfRequired(MethodVisitor mv, org.objectweb.asm.Type type) {
        if (type.getSort() <= 8) {
            switch (type.getSort()) {
                case 1: {
                    AsmUtil.unbox(mv, "java/lang/Boolean", "booleanValue", "Z");
                    break;
                }
                case 3: {
                    AsmUtil.unbox(mv, "java/lang/Byte", "byteValue", "B");
                    break;
                }
                case 2: {
                    AsmUtil.unbox(mv, "java/lang/Character", "charValue", "C");
                    break;
                }
                case 8: {
                    AsmUtil.unbox(mv, "java/lang/Double", "doubleValue", "D");
                    break;
                }
                case 6: {
                    AsmUtil.unbox(mv, "java/lang/Float", "floatValue", "F");
                    break;
                }
                case 5: {
                    AsmUtil.unbox(mv, "java/lang/Integer", "intValue", "I");
                    break;
                }
                case 7: {
                    AsmUtil.unbox(mv, "java/lang/Long", "longValue", "J");
                    break;
                }
                case 4: {
                    AsmUtil.unbox(mv, "java/lang/Short", "shortValue", "S");
                }
            }
        }
    }

    private static void unbox(MethodVisitor mv, String owner, String methodName, String returnTypeSignature) {
        mv.visitTypeInsn(192, owner);
        mv.visitMethodInsn(182, owner, methodName, "()" + returnTypeSignature, false);
    }

    public static Type[] getParameterTypes(String methodDescriptor) {
        String argsSignature = methodDescriptor.substring(methodDescriptor.indexOf(40) + 1, methodDescriptor.lastIndexOf(41));
        ArrayList<Type> args = new ArrayList<Type>();
        char[] chars = argsSignature.toCharArray();
        int dimensions = 0;
        int start = 0;
        block5: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    Type type;
                    if (dimensions == 0) {
                        type = Type.create((DotName)DotName.createSimple((String)PRIMITIVE_DESCRIPTOR_TO_PRIMITIVE_CLASS_LITERAL.get(Character.valueOf(c))), (Type.Kind)Type.Kind.PRIMITIVE);
                    } else {
                        DotName dotName = DotName.createSimple((String)("[".repeat(dimensions) + c));
                        type = Type.create((DotName)dotName, (Type.Kind)Type.Kind.ARRAY);
                    }
                    args.add(type);
                    dimensions = 0;
                    start = i + 1;
                    continue block5;
                }
                case 'L': {
                    int end = argsSignature.indexOf(59, i);
                    String binaryName = argsSignature.substring(i + 1, end);
                    if (dimensions > 0) {
                        args.add(Type.create((DotName)DotName.createSimple((String)argsSignature.substring(start, end + 1).replace('/', '.')), (Type.Kind)Type.Kind.ARRAY));
                        dimensions = 0;
                    } else {
                        args.add(Type.create((DotName)DotName.createSimple((String)binaryName.replace('/', '.')), (Type.Kind)Type.Kind.CLASS));
                    }
                    i = end;
                    start = i + 1;
                    continue block5;
                }
                case '[': {
                    ++dimensions;
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Invalid signature char: " + c);
                }
            }
        }
        return args.toArray(new Type[0]);
    }

    public static int getParameterSize(Type paramType) {
        if (paramType.kind() == Type.Kind.PRIMITIVE) {
            switch (paramType.asPrimitiveType().primitive()) {
                case DOUBLE: 
                case LONG: {
                    return 2;
                }
            }
        }
        return 1;
    }

    public static void printValueOnStderr(MethodVisitor mv, Runnable valuePusher) {
        mv.visitFieldInsn(178, "java/lang/System", "err", "Ljava/io/PrintStream;");
        valuePusher.run();
        mv.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/Object;)V", false);
    }

    public static void copyParameterNames(MethodVisitor mv, MethodInfo method) {
        int parameterSize = method.parametersCount();
        if (parameterSize > 0) {
            if (method.parameterName(0) == null) {
                return;
            }
            for (int i = 0; i < parameterSize; ++i) {
                mv.visitParameter(method.parameterName(i), 0);
            }
        }
    }

    static {
        for (int i = 0; i < PRIMITIVES.size(); ++i) {
            WRAPPER_TO_PRIMITIVE.put(WRAPPERS.get(i), PRIMITIVES.get(i));
        }
        PRIMITIVE_DESCRIPTOR_TO_PRIMITIVE_CLASS_LITERAL = Map.of(Character.valueOf('Z'), "boolean", Character.valueOf('B'), "byte", Character.valueOf('C'), "char", Character.valueOf('D'), "double", Character.valueOf('F'), "float", Character.valueOf('I'), "int", Character.valueOf('J'), "long", Character.valueOf('S'), "short");
    }
}

