/*
 * Decompiled with CFR 0.152.
 */
package waffle.servlet.spi;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import waffle.servlet.spi.SecurityFilterProvider;
import waffle.util.AuthorizationHeader;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsIdentity;

public class BasicSecurityFilterProvider
implements SecurityFilterProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicSecurityFilterProvider.class);
    private String realm = "BasicSecurityFilterProvider";
    private final IWindowsAuthProvider auth;

    public BasicSecurityFilterProvider(IWindowsAuthProvider newAuthProvider) {
        this.auth = newAuthProvider;
    }

    @Override
    public IWindowsIdentity doFilter(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AuthorizationHeader authorizationHeader = new AuthorizationHeader(request);
        String usernamePassword = new String(authorizationHeader.getTokenBytes(), StandardCharsets.UTF_8);
        String[] usernamePasswordArray = usernamePassword.split(":", 2);
        if (usernamePasswordArray.length != 2) {
            throw new RuntimeException("Invalid username:password in Authorization header.");
        }
        LOGGER.debug("logging in user: {}", (Object)usernamePasswordArray[0]);
        return this.auth.logonUser(usernamePasswordArray[0], usernamePasswordArray[1]);
    }

    @Override
    public boolean isPrincipalException(HttpServletRequest request) {
        return false;
    }

    @Override
    public boolean isSecurityPackageSupported(String securityPackage) {
        return "Basic".equalsIgnoreCase(securityPackage);
    }

    @Override
    public void sendUnauthorized(HttpServletResponse response) {
        response.addHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String value) {
        this.realm = value;
    }

    @Override
    public void initParameter(String parameterName, String parameterValue) {
        if (!"realm".equals(parameterName)) {
            throw new InvalidParameterException(parameterName);
        }
        this.setRealm(parameterValue);
    }
}

