/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.processor.generation.multipart;

import io.quarkus.gizmo.ClassOutput;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.jboss.resteasy.reactive.common.processor.AdditionalWriters;
import org.jboss.resteasy.reactive.common.processor.EndpointIndexer;
import org.jboss.resteasy.reactive.server.core.multipart.MultipartMessageBodyWriter;
import org.jboss.resteasy.reactive.server.processor.generation.multipart.FormDataOutputMapperGenerator;

public class GeneratedHandlerMultipartReturnTypeIndexerExtension
implements EndpointIndexer.MultipartReturnTypeIndexerExtension {
    private final Map<String, Boolean> multipartOutputGeneratedPopulators = new HashMap<String, Boolean>();
    final ClassOutput classOutput;

    public GeneratedHandlerMultipartReturnTypeIndexerExtension(ClassOutput classOutput) {
        this.classOutput = classOutput;
    }

    public boolean handleMultipartForReturnType(AdditionalWriters additionalWriters, ClassInfo multipartClassInfo, IndexView index) {
        String className = multipartClassInfo.name().toString();
        Boolean canHandle = this.multipartOutputGeneratedPopulators.get(className);
        if (canHandle != null) {
            return canHandle;
        }
        canHandle = false;
        if (FormDataOutputMapperGenerator.isReturnTypeCompatible(multipartClassInfo, index)) {
            additionalWriters.add(MultipartMessageBodyWriter.class.getName(), "multipart/form-data", className);
            String mapperClassName = FormDataOutputMapperGenerator.generate(multipartClassInfo, this.classOutput, index);
            canHandle = true;
        }
        this.multipartOutputGeneratedPopulators.put(className, canHandle);
        return canHandle;
    }
}

