/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension.client;

import com.webauthn4j.data.extension.HMACGetSecretInput;
import com.webauthn4j.data.extension.SingleValueExtensionInputBase;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientInput;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import org.checkerframework.checker.nullness.qual.NonNull;

public class HMACSecretAuthenticationExtensionClientInput
extends SingleValueExtensionInputBase<HMACGetSecretInput>
implements AuthenticationExtensionClientInput {
    public static final String ID = "hmac-secret";
    public static final String KEY_HMAC_GET_SECRET = "hmacGetSecret";

    public HMACSecretAuthenticationExtensionClientInput(@NonNull HMACGetSecretInput value) {
        super(value);
    }

    @Override
    public @NonNull String getIdentifier() {
        return ID;
    }

    @Override
    public @NonNull HMACGetSecretInput getValue(@NonNull String key) {
        if (!key.equals(KEY_HMAC_GET_SECRET)) {
            throw new IllegalArgumentException(String.format("%s is the only valid key.", KEY_HMAC_GET_SECRET));
        }
        return (HMACGetSecretInput)this.getValue();
    }

    @Override
    public void validate() {
        if (this.getValue() == null) {
            throw new ConstraintViolationException("value must not be null");
        }
        if (((HMACGetSecretInput)this.getValue()).getSalt1() == null) {
            throw new ConstraintViolationException("salt1 must not be null");
        }
        if (((HMACGetSecretInput)this.getValue()).getSalt1().length != 32) {
            throw new ConstraintViolationException("salt1 must be 32 bytes length");
        }
        if (((HMACGetSecretInput)this.getValue()).getSalt2() != null && ((HMACGetSecretInput)this.getValue()).getSalt2().length != 32) {
            throw new ConstraintViolationException("salt2 must be 32 bytes length");
        }
    }
}

