/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension;

import com.webauthn4j.util.ArrayUtil;
import java.io.Serializable;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HMACGetSecretInput
implements Serializable {
    private final byte[] salt1;
    private final byte[] salt2;

    public HMACGetSecretInput(@NonNull byte[] salt1, @Nullable byte[] salt2) {
        this.salt1 = ArrayUtil.clone((byte[])salt1);
        this.salt2 = ArrayUtil.clone((byte[])salt2);
    }

    public HMACGetSecretInput(@NonNull byte[] salt1) {
        this.salt1 = ArrayUtil.clone((byte[])salt1);
        this.salt2 = null;
    }

    public @NonNull byte[] getSalt1() {
        return ArrayUtil.clone((byte[])this.salt1);
    }

    public @Nullable byte[] getSalt2() {
        return ArrayUtil.clone((byte[])this.salt2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HMACGetSecretInput that = (HMACGetSecretInput)o;
        return Arrays.equals(this.salt1, that.salt1) && Arrays.equals(this.salt2, that.salt2);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.salt1);
        result = 31 * result + Arrays.hashCode(this.salt2);
        return result;
    }
}

