/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.webauthn4j.data.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@JsonIgnoreProperties(value={"format"})
@JsonTypeName(value="packed")
public class PackedAttestationStatement
implements CertificateBaseAttestationStatement {
    public static final String FORMAT = "packed";
    @JsonProperty
    private final COSEAlgorithmIdentifier alg;
    @JsonProperty
    private final byte[] sig;
    @JsonProperty
    private final AttestationCertificatePath x5c;

    public PackedAttestationStatement(@JsonProperty(value="alg") @NonNull COSEAlgorithmIdentifier alg, @JsonProperty(value="sig") @NonNull byte[] sig, @JsonProperty(value="x5c") @Nullable AttestationCertificatePath x5c) {
        AssertUtil.notNull((Object)alg, (String)"alg must not be null");
        AssertUtil.notNull((Object)sig, (String)"sig must not be null");
        this.alg = alg;
        this.sig = sig;
        this.x5c = x5c;
    }

    public @NonNull COSEAlgorithmIdentifier getAlg() {
        return this.alg;
    }

    public @NonNull byte[] getSig() {
        return ArrayUtil.clone((byte[])this.sig);
    }

    @Override
    public @Nullable AttestationCertificatePath getX5c() {
        return this.x5c;
    }

    @Override
    @JsonIgnore
    public @NonNull String getFormat() {
        return FORMAT;
    }

    @Override
    public void validate() {
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackedAttestationStatement that = (PackedAttestationStatement)o;
        return Objects.equals(this.alg, that.alg) && Arrays.equals(this.sig, that.sig) && Objects.equals(this.x5c, that.x5c);
    }

    public int hashCode() {
        int result = Objects.hash(this.alg, this.x5c);
        result = 31 * result + Arrays.hashCode(this.sig);
        return result;
    }

    public String toString() {
        return "PackedAttestationStatement(alg=" + this.alg + ", sig=" + ArrayUtil.toHexString((byte[])this.sig) + ", x5c=" + this.x5c + ')';
    }
}

