/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern.sender;

import biz.paluch.logging.gelf.intern.ErrorReporter;
import biz.paluch.logging.gelf.intern.GelfMessage;
import biz.paluch.logging.gelf.intern.GelfSender;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.util.Pool;

public class GelfREDISSender<T>
implements GelfSender {
    private final Pool<Jedis> jedisPool;
    private final ErrorReporter errorReporter;
    private final String redisKey;
    private final Set<Thread> callers = Collections.newSetFromMap(new WeakHashMap());

    public GelfREDISSender(Pool<Jedis> jedisPool, String redisKey, ErrorReporter errorReporter) {
        this.jedisPool = jedisPool;
        this.errorReporter = errorReporter;
        this.redisKey = redisKey;
    }

    @Override
    public boolean sendMessage(GelfMessage message) {
        if (!this.callers.add(Thread.currentThread())) {
            return false;
        }
        try {
            boolean bl = this.sendMessage0(message);
            return bl;
        }
        finally {
            this.callers.remove(Thread.currentThread());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean sendMessage0(GelfMessage message) {
        try (Jedis jedisClient = (Jedis)this.jedisPool.getResource();){
            jedisClient.lpush(this.redisKey, new String[]{message.toJson("")});
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.errorReporter.reportError(e.getMessage(), new IOException("Cannot send REDIS data with key URI " + this.redisKey, e));
            return false;
        }
    }

    @Override
    public void close() {
        this.callers.clear();
        this.jedisPool.destroy();
    }
}

