/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.runtime.mappers;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import io.quarkus.runtime.LaunchMode;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.util.List;

public class DefaultMismatchedInputException
implements ExceptionMapper<MismatchedInputException> {
    public Response toResponse(MismatchedInputException exception) {
        List path;
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
        if (LaunchMode.current().isDevOrTest() && (path = exception.getPath()) != null && !path.isEmpty()) {
            MismatchedJsonInputError.Builder errorBuilder = new MismatchedJsonInputError.Builder(((JsonMappingException.Reference)path.get(0)).getFrom().getClass().getSimpleName());
            StringBuilder attributeNameBuilder = new StringBuilder();
            for (JsonMappingException.Reference pathReference : path) {
                if (pathReference.getFieldName() != null) {
                    if (attributeNameBuilder.length() > 0) {
                        attributeNameBuilder.append(".");
                    }
                    attributeNameBuilder.append(pathReference.getFieldName());
                }
                if (pathReference.getIndex() < 0) continue;
                attributeNameBuilder.append("[");
                attributeNameBuilder.append(pathReference.getIndex());
                attributeNameBuilder.append("]");
            }
            if (attributeNameBuilder.length() > 0) {
                errorBuilder.setAttributeName(attributeNameBuilder.toString());
            }
            if (exception.getLocation() != null) {
                InvalidFormatException ife;
                errorBuilder.setLine(exception.getLocation().getLineNr());
                errorBuilder.setColumn(exception.getLocation().getColumnNr());
                if (exception instanceof InvalidFormatException && (ife = (InvalidFormatException)exception).getValue() != null) {
                    errorBuilder.setValue(ife.getValue());
                }
            }
            responseBuilder.entity((Object)errorBuilder.build());
        }
        return responseBuilder.build();
    }

    public static class MismatchedJsonInputError {
        private final String objectName;
        private final String attributeName;
        private final Integer line;
        private final Integer column;
        private final Object value;

        private MismatchedJsonInputError(Builder builder) {
            this.objectName = builder.objectName;
            this.attributeName = builder.attributeName;
            this.line = builder.line;
            this.column = builder.column;
            this.value = builder.value;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public Integer getLine() {
            return this.line;
        }

        public Integer getColumn() {
            return this.column;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return "MismatchedJsonInputError{objectName='" + this.objectName + "', attributeName='" + this.attributeName + "', line=" + this.line + ", column=" + this.column + ", value='" + this.value + "'}";
        }

        static class Builder {
            private final String objectName;
            private String attributeName;
            private Integer line;
            private Integer column;
            private Object value;

            public Builder(String objectName) {
                this.objectName = objectName;
            }

            public Builder setAttributeName(String attributeName) {
                this.attributeName = attributeName;
                return this;
            }

            public Builder setLine(Integer line) {
                this.line = line;
                return this;
            }

            public Builder setColumn(Integer column) {
                this.column = column;
                return this;
            }

            public Builder setValue(Object value) {
                this.value = value;
                return this;
            }

            public MismatchedJsonInputError build() {
                return new MismatchedJsonInputError(this);
            }
        }
    }
}

