/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment.binder;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import java.util.function.BooleanSupplier;

public class KafkaBinderProcessor {
    static final String KAFKA_CONSUMER_CLASS_NAME = "org.apache.kafka.clients.consumer.Consumer";
    static final Class<?> KAFKA_CONSUMER_CLASS_CLASS = MicrometerRecorder.getClassForName((String)"org.apache.kafka.clients.consumer.Consumer");
    static final String KAFKA_STREAMS_CLASS_NAME = "org.apache.kafka.streams.KafkaStreams";
    static final Class<?> KAFKA_STREAMS_CLASS_CLASS = MicrometerRecorder.getClassForName((String)"org.apache.kafka.streams.KafkaStreams");
    static final String KAFKA_EVENT_CONSUMER_CLASS_NAME = "io.quarkus.micrometer.runtime.binder.kafka.KafkaEventObserver";
    static final String KAFKA_STREAMS_METRICS_PRODUCER_CLASS_NAME = "io.quarkus.micrometer.runtime.binder.kafka.KafkaStreamsEventObserver";

    @BuildStep(onlyIf={KafkaSupportEnabled.class})
    AdditionalBeanBuildItem createCDIEventConsumer() {
        return AdditionalBeanBuildItem.builder().addBeanClass(KAFKA_EVENT_CONSUMER_CLASS_NAME).setUnremovable().build();
    }

    @BuildStep(onlyIf={KafkaStreamsSupportEnabled.class})
    AdditionalBeanBuildItem createKafkaStreamsEventObserver() {
        return AdditionalBeanBuildItem.builder().addBeanClass(KAFKA_STREAMS_METRICS_PRODUCER_CLASS_NAME).setUnremovable().build();
    }

    static class KafkaStreamsSupportEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;

        KafkaStreamsSupportEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return KAFKA_STREAMS_CLASS_CLASS != null && this.mConfig.checkBinderEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.mConfig.binder.kafka);
        }
    }

    static class KafkaSupportEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;

        KafkaSupportEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return KAFKA_CONSUMER_CLASS_CLASS != null && this.mConfig.checkBinderEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.mConfig.binder.kafka);
        }
    }
}

