/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.CompletedStage;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Futures;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;

public final class EvaluatedParams {
    static final EvaluatedParams EMPTY = new EvaluatedParams(CompletedStage.ofVoid(), new Supplier[0]);
    public final CompletionStage<?> stage;
    private final Supplier<?>[] results;

    public static EvaluatedParams evaluate(EvalContext context) {
        List<Expression> params = context.getParams();
        if (params.isEmpty()) {
            return EMPTY;
        }
        if (params.size() == 1) {
            return new EvaluatedParams(context.evaluate(params.get(0)));
        }
        Supplier[] allResults = new Supplier[params.size()];
        ArrayList<CompletableFuture<Object>> asyncResults = null;
        int i = 0;
        CompletedStage failure = null;
        for (Expression expression : params) {
            CompletionStage<Object> result = context.evaluate(expression);
            if (result instanceof CompletedStage) {
                CompletedStage completed = (CompletedStage)result;
                allResults[i++] = completed;
                if (!completed.isFailure()) continue;
                failure = completed;
                continue;
            }
            CompletableFuture<Object> fu = result.toCompletableFuture();
            if (asyncResults == null) {
                asyncResults = new ArrayList<CompletableFuture<Object>>();
            }
            asyncResults.add(fu);
            allResults[i++] = Futures.toSupplier(fu);
        }
        CompletionStage<Object> cs = asyncResults == null ? (failure != null ? failure : CompletedStage.ofVoid()) : (asyncResults.size() == 1 ? (CompletionStage)asyncResults.get(0) : CompletableFuture.allOf(asyncResults.toArray(new CompletableFuture[0])));
        return new EvaluatedParams(cs, allResults);
    }

    public static EvaluatedParams evaluateMessageKey(EvalContext context) {
        List<Expression> params = context.getParams();
        if (params.isEmpty()) {
            throw new IllegalArgumentException("No params to evaluate");
        }
        return new EvaluatedParams(context.evaluate(params.get(0)));
    }

    public static EvaluatedParams evaluateMessageParams(EvalContext context) {
        List<Expression> params = context.getParams();
        if (params.size() < 2) {
            return EMPTY;
        }
        Supplier[] allResults = new Supplier[params.size()];
        ArrayList<CompletableFuture<Object>> asyncResults = null;
        int i = 0;
        CompletedStage failure = null;
        Iterator<Expression> it = params.subList(1, params.size()).iterator();
        while (it.hasNext()) {
            CompletionStage<Object> result = context.evaluate(it.next());
            if (result instanceof CompletedStage) {
                CompletedStage completed = (CompletedStage)result;
                allResults[i++] = completed;
                if (!completed.isFailure()) continue;
                failure = completed;
                continue;
            }
            CompletableFuture<Object> fu = result.toCompletableFuture();
            if (asyncResults == null) {
                asyncResults = new ArrayList<CompletableFuture<Object>>();
            }
            asyncResults.add(fu);
            allResults[i++] = Futures.toSupplier(fu);
        }
        CompletionStage<Object> cs = asyncResults == null ? (failure != null ? failure : CompletedStage.ofVoid()) : (asyncResults.size() == 1 ? (CompletionStage)asyncResults.get(0) : CompletableFuture.allOf(asyncResults.toArray(new CompletableFuture[0])));
        return new EvaluatedParams(cs, allResults);
    }

    EvaluatedParams(CompletionStage<?> stage) {
        this.stage = stage;
        this.results = stage instanceof CompletedStage ? new Supplier[]{(CompletedStage)stage} : new Supplier[]{Futures.toSupplier(stage.toCompletableFuture())};
    }

    EvaluatedParams(CompletionStage<?> stage, Supplier<?>[] results) {
        this.stage = stage;
        this.results = results;
    }

    public Object getResult(int index) throws InterruptedException, ExecutionException {
        return this.results[index].get();
    }

    public boolean parameterTypesMatch(boolean varargs, Class<?>[] types) throws InterruptedException, ExecutionException {
        if (types.length == this.results.length) {
            if (varargs) {
                types[types.length - 1] = types[types.length - 1].getComponentType();
            }
        } else if (varargs) {
            int diff = types.length - this.results.length;
            if (diff > 1) {
                return false;
            }
            if (diff < 1) {
                Class<?> varargsType = types[types.length - 1];
                types[types.length - 1] = varargsType.getComponentType();
            }
        } else {
            return false;
        }
        int i = 0;
        Class<?> paramType = EvaluatedParams.boxType(types[i]);
        while (i < this.results.length) {
            Class<?> resultClass;
            Object result = this.getResult(i);
            if (result != null && !paramType.isAssignableFrom(resultClass = EvaluatedParams.boxType(result.getClass()))) {
                return false;
            }
            if (types.length <= ++i) continue;
            paramType = EvaluatedParams.boxType(types[i]);
        }
        return true;
    }

    public Object getVarargsResults(int numberOfParameters, Class<?> componentType) throws InterruptedException, ExecutionException {
        int skip = numberOfParameters - 1;
        if (skip < 0) {
            return Array.newInstance(componentType, 0);
        }
        int idx = 0;
        Object array = Array.newInstance(componentType, this.results.length - skip);
        for (int i = skip; i < this.results.length; ++i) {
            Object result = this.getResult(i);
            Array.set(array, idx++, result);
        }
        return array;
    }

    private static Class<?> boxType(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (type.equals(Character.TYPE)) {
            return Character.class;
        }
        if (type.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type.equals(Short.TYPE)) {
            return Short.class;
        }
        if (type.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (type.equals(Long.TYPE)) {
            return Long.class;
        }
        if (type.equals(Float.TYPE)) {
            return Float.class;
        }
        if (type.equals(Double.TYPE)) {
            return Double.class;
        }
        if (type.equals(Void.TYPE)) {
            return Void.class;
        }
        throw new IllegalArgumentException();
    }
}

