/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

@Extension(name="x-smallrye-profile-admin", value="")
public class ClientScopeEvaluateScopeMappingsResource {
    private final RoleContainerModel roleContainer;
    private final AdminPermissionEvaluator auth;
    private final ClientModel client;
    private final String scopeParam;

    public ClientScopeEvaluateScopeMappingsResource(RoleContainerModel roleContainer, AdminPermissionEvaluator auth, ClientModel client, String scopeParam) {
        this.roleContainer = roleContainer;
        this.auth = auth;
        this.client = client;
        this.scopeParam = scopeParam;
    }

    @Path(value="/granted")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Clients")
    @Operation(summary="Get effective scope mapping of all roles of particular role container, which this client is defacto allowed to have in the accessToken issued for him.", description="This contains scope mappings, which this client has directly, as well as scope mappings, which are granted to all client scopes, which are linked with this client.")
    public Stream<RoleRepresentation> getGrantedScopeMappings() {
        return this.getGrantedRoles().map(ModelToRepresentation::toBriefRepresentation);
    }

    @Path(value="/not-granted")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Clients")
    @Operation(summary="Get roles, which this client doesn't have scope for and can't have them in the accessToken issued for him.", description="Defacto all the other roles of particular role container, which are not in {@link #getGrantedScopeMappings()}")
    public Stream<RoleRepresentation> getNotGrantedScopeMappings() {
        Set grantedRoles = this.getGrantedRoles().collect(Collectors.toSet());
        return this.roleContainer.getRolesStream().filter(((Predicate<RoleModel>)grantedRoles::contains).negate()).map(ModelToRepresentation::toBriefRepresentation);
    }

    private Stream<RoleModel> getGrantedRoles() {
        if (this.client.isFullScopeAllowed()) {
            return this.roleContainer.getRolesStream();
        }
        Set clientScopes = TokenManager.getRequestedClientScopes(this.scopeParam, this.client).collect(Collectors.toSet());
        Predicate<RoleModel> hasClientScope = role -> clientScopes.stream().anyMatch(scopeContainer -> scopeContainer.hasScope(role));
        return this.roleContainer.getRolesStream().filter(this.auth.roles()::canView).filter(hasClientScope);
    }
}

