/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clienttype.impl;

import java.util.Optional;
import java.util.Set;
import org.keycloak.client.clienttype.ClientType;
import org.keycloak.models.ClientModel;
import org.keycloak.representations.idm.ClientTypeRepresentation;
import org.keycloak.services.clienttype.client.TypeAwareClientModelDelegate;

public class DefaultClientType
implements ClientType {
    private final ClientTypeRepresentation clientType;

    public DefaultClientType(ClientTypeRepresentation clientType) {
        this.clientType = clientType;
    }

    public String getName() {
        return this.clientType.getName();
    }

    public boolean isApplicable(String optionName) {
        return this.getConfiguration(optionName).map(ClientTypeRepresentation.PropertyConfig::getApplicable).orElse(true);
    }

    public <T> T getTypeValue(String optionName, Class<T> optionType) {
        return this.getConfiguration(optionName).map(ClientTypeRepresentation.PropertyConfig::getValue).map(optionType::cast).orElse(null);
    }

    public Set<String> getOptionNames() {
        return this.clientType.getConfig().keySet();
    }

    public ClientModel augment(ClientModel client) {
        return new TypeAwareClientModelDelegate(this, () -> client);
    }

    private Optional<ClientTypeRepresentation.PropertyConfig> getConfiguration(String optionName) {
        return Optional.ofNullable((ClientTypeRepresentation.PropertyConfig)this.clientType.getConfig().get(optionName));
    }
}

