/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clienttype.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.keycloak.client.clienttype.ClientType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.delegate.ClientModelLazyDelegate;
import org.keycloak.services.clienttype.client.TypedClientExtendedAttribute;
import org.keycloak.services.clienttype.client.TypedClientSimpleAttribute;

public class TypeAwareClientModelDelegate
extends ClientModelLazyDelegate {
    private final ClientType clientType;

    public TypeAwareClientModelDelegate(ClientType clientType, Supplier<ClientModel> clientModelSupplier) {
        super(clientModelSupplier);
        if (clientType == null) {
            throw new IllegalArgumentException("Null client type not supported for client " + this.getClientId());
        }
        this.clientType = clientType;
    }

    public boolean isStandardFlowEnabled() {
        return TypedClientSimpleAttribute.STANDARD_FLOW_ENABLED.getClientAttribute(this.clientType, Boolean.class);
    }

    public void setStandardFlowEnabled(boolean standardFlowEnabled) {
        TypedClientSimpleAttribute.STANDARD_FLOW_ENABLED.setClientAttribute(this.clientType, standardFlowEnabled, x$0 -> super.setStandardFlowEnabled(x$0), Boolean.class);
    }

    public boolean isBearerOnly() {
        return TypedClientSimpleAttribute.BEARER_ONLY.getClientAttribute(this.clientType, Boolean.class);
    }

    public void setBearerOnly(boolean bearerOnly) {
        TypedClientSimpleAttribute.BEARER_ONLY.setClientAttribute(this.clientType, bearerOnly, x$0 -> super.setBearerOnly(x$0), Boolean.class);
    }

    public boolean isConsentRequired() {
        return TypedClientSimpleAttribute.CONSENT_REQUIRED.getClientAttribute(this.clientType, Boolean.class);
    }

    public void setConsentRequired(boolean consentRequired) {
        TypedClientSimpleAttribute.CONSENT_REQUIRED.setClientAttribute(this.clientType, consentRequired, x$0 -> super.setConsentRequired(x$0), Boolean.class);
    }

    public boolean isDirectAccessGrantsEnabled() {
        return TypedClientSimpleAttribute.DIRECT_ACCESS_GRANTS_ENABLED.getClientAttribute(this.clientType, Boolean.class);
    }

    public void setDirectAccessGrantsEnabled(boolean directAccessGrantsEnabled) {
        TypedClientSimpleAttribute.DIRECT_ACCESS_GRANTS_ENABLED.setClientAttribute(this.clientType, directAccessGrantsEnabled, x$0 -> super.setDirectAccessGrantsEnabled(x$0), Boolean.class);
    }

    public boolean isAlwaysDisplayInConsole() {
        return TypedClientSimpleAttribute.ALWAYS_DISPLAY_IN_CONSOLE.getClientAttribute(this.clientType, Boolean.class);
    }

    public void setAlwaysDisplayInConsole(boolean alwaysDisplayInConsole) {
        TypedClientSimpleAttribute.ALWAYS_DISPLAY_IN_CONSOLE.setClientAttribute(this.clientType, alwaysDisplayInConsole, x$0 -> super.setAlwaysDisplayInConsole(x$0), Boolean.class);
    }

    public boolean isFrontchannelLogout() {
        return TypedClientSimpleAttribute.FRONTCHANNEL_LOGOUT.getClientAttribute(this.clientType, Boolean.class);
    }

    public void setFrontchannelLogout(boolean frontchannelLogout) {
        TypedClientSimpleAttribute.FRONTCHANNEL_LOGOUT.setClientAttribute(this.clientType, frontchannelLogout, x$0 -> super.setFrontchannelLogout(x$0), Boolean.class);
    }

    public boolean isImplicitFlowEnabled() {
        return TypedClientSimpleAttribute.IMPLICIT_FLOW_ENABLED.getClientAttribute(this.clientType, Boolean.class);
    }

    public void setImplicitFlowEnabled(boolean implicitFlowEnabled) {
        TypedClientSimpleAttribute.IMPLICIT_FLOW_ENABLED.setClientAttribute(this.clientType, implicitFlowEnabled, x$0 -> super.setImplicitFlowEnabled(x$0), Boolean.class);
    }

    public boolean isServiceAccountsEnabled() {
        return TypedClientSimpleAttribute.SERVICE_ACCOUNTS_ENABLED.getClientAttribute(this.clientType, Boolean.class);
    }

    public void setServiceAccountsEnabled(boolean flag) {
        TypedClientSimpleAttribute.SERVICE_ACCOUNTS_ENABLED.setClientAttribute(this.clientType, flag, x$0 -> super.setServiceAccountsEnabled(x$0), Boolean.class);
    }

    public String getProtocol() {
        return TypedClientSimpleAttribute.PROTOCOL.getClientAttribute(this.clientType, String.class);
    }

    public void setProtocol(String protocol) {
        TypedClientSimpleAttribute.PROTOCOL.setClientAttribute(this.clientType, protocol, x$0 -> super.setProtocol(x$0), String.class);
    }

    public boolean isPublicClient() {
        return TypedClientSimpleAttribute.PUBLIC_CLIENT.getClientAttribute(this.clientType, Boolean.class);
    }

    public void setPublicClient(boolean flag) {
        TypedClientSimpleAttribute.PUBLIC_CLIENT.setClientAttribute(this.clientType, flag, x$0 -> super.setPublicClient(x$0), Boolean.class);
    }

    public Set<String> getWebOrigins() {
        return TypedClientSimpleAttribute.WEB_ORIGINS.getClientAttribute(this.clientType, Set.class);
    }

    public void setWebOrigins(Set<String> webOrigins) {
        TypedClientSimpleAttribute.WEB_ORIGINS.setClientAttribute(this.clientType, webOrigins, x$0 -> super.setWebOrigins(x$0), Set.class);
    }

    public void addWebOrigin(String webOrigin) {
        TypedClientSimpleAttribute.WEB_ORIGINS.setClientAttribute(this.clientType, webOrigin, x$0 -> super.addWebOrigin(x$0), String.class);
    }

    public void removeWebOrigin(String webOrigin) {
        TypedClientSimpleAttribute.WEB_ORIGINS.setClientAttribute(this.clientType, null, val -> super.removeWebOrigin(webOrigin), String.class);
    }

    public Set<String> getRedirectUris() {
        return TypedClientSimpleAttribute.REDIRECT_URIS.getClientAttribute(this.clientType, Set.class);
    }

    public void setRedirectUris(Set<String> redirectUris) {
        TypedClientSimpleAttribute.REDIRECT_URIS.setClientAttribute(this.clientType, redirectUris, x$0 -> super.setRedirectUris(x$0), Set.class);
    }

    public void addRedirectUri(String redirectUri) {
        TypedClientSimpleAttribute.REDIRECT_URIS.setClientAttribute(this.clientType, redirectUri, x$0 -> super.addRedirectUri(x$0), String.class);
    }

    public void removeRedirectUri(String redirectUri) {
        TypedClientSimpleAttribute.REDIRECT_URIS.setClientAttribute(this.clientType, null, val -> super.removeRedirectUri(redirectUri), String.class);
    }

    public void setAttribute(String name, String value) {
        TypedClientExtendedAttribute attribute = TypedClientExtendedAttribute.getAttributesByName().get(name);
        if (attribute != null) {
            attribute.setClientAttribute(this.clientType, value, newValue -> super.setAttribute(name, newValue), String.class);
        } else {
            super.setAttribute(name, value);
        }
    }

    public void removeAttribute(String name) {
        TypedClientExtendedAttribute attribute = TypedClientExtendedAttribute.getAttributesByName().get(name);
        if (attribute != null) {
            attribute.setClientAttribute(this.clientType, null, val -> super.removeAttribute(name), String.class);
        } else {
            super.removeAttribute(name);
        }
    }

    public String getAttribute(String name) {
        TypedClientExtendedAttribute attribute = TypedClientExtendedAttribute.getAttributesByName().get(name);
        if (attribute != null) {
            return attribute.getClientAttribute(this.clientType, String.class);
        }
        return super.getAttribute(name);
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>(super.getAttributes());
        Set extendedClientTypeAttributes = this.clientType.getOptionNames().stream().filter(optionName -> TypedClientExtendedAttribute.getAttributesByName().containsKey(optionName)).collect(Collectors.toSet());
        for (String entry : extendedClientTypeAttributes) {
            attributes.put(entry, this.getAttribute(entry));
        }
        return attributes;
    }
}

