/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.Profile;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.JsonConfigComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.ClientPoliciesRepresentation;
import org.keycloak.representations.idm.ClientPolicyConditionConfigurationRepresentation;
import org.keycloak.representations.idm.ClientPolicyConditionRepresentation;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.representations.idm.ClientPolicyExecutorRepresentation;
import org.keycloak.representations.idm.ClientPolicyRepresentation;
import org.keycloak.representations.idm.ClientProfileRepresentation;
import org.keycloak.representations.idm.ClientProfilesRepresentation;
import org.keycloak.securityprofile.SecurityProfileProvider;
import org.keycloak.services.clientpolicy.ClientPolicy;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientProfile;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.util.JsonSerialization;

public class ClientPoliciesUtil {
    private static final Logger logger = Logger.getLogger(ClientPoliciesUtil.class);

    public static InputStream getJsonFileFromClasspathOrConfFolder(String name) throws IOException {
        String fileName = name + ".json";
        InputStream is = ClientPoliciesUtil.class.getResourceAsStream("/" + fileName);
        if (is == null) {
            Path path = Paths.get(System.getProperty("jboss.server.config.dir"), new String[0]).resolve(fileName);
            if (!Files.isReadable(path)) {
                throw new IOException(String.format("File \"%s\" does not exists under the config folder", path));
            }
            is = Files.newInputStream(path, new OpenOption[0]);
        }
        return is;
    }

    public static List<ClientProfileRepresentation> readGlobalClientProfilesRepresentation(KeycloakSession session, String name) throws ClientPolicyException {
        List<ClientProfileRepresentation> list;
        block9: {
            if (name == null) {
                return Collections.emptyList();
            }
            InputStream is = ClientPoliciesUtil.getJsonFileFromClasspathOrConfFolder(name);
            try {
                list = ClientPoliciesUtil.getValidatedGlobalClientProfilesRepresentation(session, is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ClientPolicyException("Error reading profiles from " + name, e.getMessage(), (Throwable)e);
                }
            }
            is.close();
        }
        return list;
    }

    public static List<ClientPolicyRepresentation> readGlobalClientPoliciesRepresentation(KeycloakSession session, String name, List<ClientProfileRepresentation> profiles) throws ClientPolicyException {
        List<ClientPolicyRepresentation> list;
        block9: {
            if (name == null) {
                return Collections.emptyList();
            }
            InputStream is = ClientPoliciesUtil.getJsonFileFromClasspathOrConfFolder(name);
            try {
                list = ClientPoliciesUtil.getValidatedGlobalClientPoliciesRepresentation(session, is, profiles);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ClientPolicyException("Error reading profiles from " + name, e.getMessage(), (Throwable)e);
                }
            }
            is.close();
        }
        return list;
    }

    static ClientProfilesRepresentation getClientProfilesRepresentation(KeycloakSession session, RealmModel realm) throws ClientPolicyException {
        String profilesJson = ClientPoliciesUtil.getClientProfilesJsonString(realm);
        if (profilesJson == null) {
            return new ClientProfilesRepresentation();
        }
        return ClientPoliciesUtil.convertClientProfilesJsonToRepresentation(profilesJson);
    }

    static ClientProfile getClientProfileModel(KeycloakSession session, RealmModel realm, ClientProfilesRepresentation profilesRep, List<ClientProfileRepresentation> globalClientProfiles, String profileName) throws ClientPolicyException {
        ArrayList<ClientProfileRepresentation> profiles = profilesRep.getProfiles();
        if (profiles == null) {
            profiles = new ArrayList<ClientProfileRepresentation>();
        }
        profiles.addAll(globalClientProfiles);
        ClientProfileRepresentation profileRep = profiles.stream().filter(clientProfile -> profileName.equals(clientProfile.getName())).findFirst().orElse(null);
        if (profileRep == null) {
            return null;
        }
        ClientProfile profileModel = new ClientProfile();
        profileModel.setName(profileRep.getName());
        profileModel.setDescription(profileRep.getDescription());
        if (profileRep.getExecutors() == null) {
            profileModel.setExecutors(new ArrayList<ClientPolicyExecutorProvider>());
            return profileModel;
        }
        ArrayList<ClientPolicyExecutorProvider> executors = new ArrayList<ClientPolicyExecutorProvider>();
        if (profileRep.getExecutors() != null) {
            for (ClientPolicyExecutorRepresentation executorRep : profileRep.getExecutors()) {
                ClientPolicyExecutorProvider provider = ClientPoliciesUtil.getExecutorProvider(session, realm, executorRep.getExecutorProviderId(), executorRep.getConfiguration());
                executors.add(provider);
            }
        }
        profileModel.setExecutors(executors);
        return profileModel;
    }

    private static ClientPolicyExecutorProvider getExecutorProvider(KeycloakSession session, RealmModel realm, String providerId, JsonNode config) {
        JsonConfigComponentModel componentModel = new JsonConfigComponentModel(ClientPolicyExecutorProvider.class, realm.getId(), providerId, config);
        ClientPolicyExecutorProvider executorProvider = (ClientPolicyExecutorProvider)session.getComponentProvider(ClientPolicyExecutorProvider.class, componentModel.getId(), arg_0 -> ClientPoliciesUtil.lambda$getExecutorProvider$1((ComponentModel)componentModel, arg_0));
        if (executorProvider == null) {
            throw new IllegalStateException("Executor with provider ID " + providerId + " not found");
        }
        ClientPolicyExecutorConfigurationRepresentation configuration = (ClientPolicyExecutorConfigurationRepresentation)JsonSerialization.mapper.convertValue((Object)config, executorProvider.getExecutorConfigurationClass());
        executorProvider.setupConfiguration(configuration);
        return executorProvider;
    }

    static List<ClientProfileRepresentation> getValidatedGlobalClientProfilesRepresentation(KeycloakSession session, InputStream is) throws ClientPolicyException {
        ClientProfilesRepresentation proposedProfilesRep = null;
        try {
            proposedProfilesRep = (ClientProfilesRepresentation)JsonSerialization.readValue((InputStream)is, ClientProfilesRepresentation.class);
        }
        catch (Exception e) {
            throw new ClientPolicyException("failed to deserialize global proposed client profiles json string.", e.getMessage());
        }
        if (proposedProfilesRep == null) {
            return Collections.emptyList();
        }
        List proposedProfileRepList = proposedProfilesRep.getProfiles();
        if (proposedProfileRepList == null || proposedProfileRepList.isEmpty()) {
            return Collections.emptyList();
        }
        if ((long)proposedProfileRepList.size() != proposedProfileRepList.stream().map(i -> i.getName()).distinct().count()) {
            throw new ClientPolicyException("proposed global client profile name duplicated.");
        }
        LinkedList<ClientProfileRepresentation> updatingProfileList = new LinkedList<ClientProfileRepresentation>();
        for (ClientProfileRepresentation proposedProfileRep : proposedProfilesRep.getProfiles()) {
            if (proposedProfileRep.getName() == null) {
                throw new ClientPolicyException("client profile without its name not allowed.");
            }
            ClientProfileRepresentation profileRep = new ClientProfileRepresentation();
            profileRep.setName(proposedProfileRep.getName());
            profileRep.setDescription(proposedProfileRep.getDescription());
            profileRep.setExecutors(new ArrayList());
            if (proposedProfileRep.getExecutors() != null) {
                for (ClientPolicyExecutorRepresentation executorRep : proposedProfileRep.getExecutors()) {
                    if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.CLIENT_POLICIES) && !ClientPoliciesUtil.isValidExecutor(session, executorRep)) {
                        throw new ClientPolicyException("proposed client profile contains the executor with its invalid configuration.");
                    }
                    profileRep.getExecutors().add(executorRep);
                }
            }
            updatingProfileList.add(profileRep);
        }
        return updatingProfileList;
    }

    static List<ClientPolicyRepresentation> getValidatedGlobalClientPoliciesRepresentation(KeycloakSession session, InputStream is, List<ClientProfileRepresentation> profiles) throws ClientPolicyException {
        ClientPoliciesRepresentation proposedPoliciesRep = null;
        try {
            proposedPoliciesRep = (ClientPoliciesRepresentation)JsonSerialization.readValue((InputStream)is, ClientPoliciesRepresentation.class);
        }
        catch (Exception e) {
            throw new ClientPolicyException("failed to deserialize global proposed client profiles json string.", e.getMessage());
        }
        if (proposedPoliciesRep == null) {
            return Collections.emptyList();
        }
        return ClientPoliciesUtil.validatePolicies(session, proposedPoliciesRep.getPolicies(), profiles, Collections.emptyList());
    }

    public static String convertClientProfilesRepresentationToJson(ClientProfilesRepresentation reps) throws ClientPolicyException {
        try {
            return JsonSerialization.writeValueAsString((Object)reps);
        }
        catch (IOException ioe) {
            throw new ClientPolicyException(ioe.getMessage());
        }
    }

    private static ClientProfilesRepresentation convertClientProfilesJsonToRepresentation(String json) throws ClientPolicyException {
        try {
            return (ClientProfilesRepresentation)JsonSerialization.readValue((String)json, ClientProfilesRepresentation.class);
        }
        catch (IOException ioe) {
            throw new ClientPolicyException(ioe.getMessage());
        }
    }

    static ClientProfilesRepresentation getValidatedClientProfilesForUpdate(KeycloakSession session, RealmModel realm, ClientProfilesRepresentation proposedProfilesRep, List<ClientProfileRepresentation> globalClientProfiles) throws ClientPolicyException {
        if (realm == null) {
            throw new ClientPolicyException("realm not specified.");
        }
        ArrayList proposedProfileRepList = proposedProfilesRep.getProfiles();
        if (proposedProfileRepList == null || proposedProfileRepList.isEmpty()) {
            proposedProfileRepList = new ArrayList();
            proposedProfilesRep.setProfiles(new ArrayList());
        }
        if (proposedProfileRepList.stream().anyMatch(clientProfile -> clientProfile.getName() == null || clientProfile.getName().isEmpty())) {
            throw new ClientPolicyException("client profile without its name not allowed.");
        }
        if ((long)proposedProfileRepList.size() != proposedProfileRepList.stream().map(i -> i.getName()).distinct().count()) {
            throw new ClientPolicyException("proposed client profile name duplicated.");
        }
        if (ClientPoliciesUtil.isGlobalProfilesUpdated(proposedProfilesRep.getGlobalProfiles(), globalClientProfiles)) {
            throw new ClientPolicyException("Global profiles cannot be updated");
        }
        Set globalProfileNames = globalClientProfiles.stream().map(ClientProfileRepresentation::getName).collect(Collectors.toSet());
        for (ClientProfileRepresentation clientProfile2 : proposedProfileRepList) {
            if (!globalProfileNames.contains(clientProfile2.getName())) continue;
            throw new ClientPolicyException("Proposed profile name '" + clientProfile2.getName() + "' is duplicated as a global profile");
        }
        for (ClientProfileRepresentation proposedProfileRep : proposedProfilesRep.getProfiles()) {
            if (proposedProfileRep.getExecutors() == null) continue;
            for (ClientPolicyExecutorRepresentation executorRep : proposedProfileRep.getExecutors()) {
                if (ClientPoliciesUtil.isValidExecutor(session, executorRep)) continue;
                proposedProfileRep.getExecutors().remove(executorRep);
                throw new ClientPolicyException("proposed client profile contains the executor, which does not have valid provider, or has invalid configuration.");
            }
        }
        proposedProfilesRep.setGlobalProfiles(null);
        return proposedProfilesRep;
    }

    private static boolean isGlobalProfilesUpdated(List<ClientProfileRepresentation> proposedGlobalProfiles, List<ClientProfileRepresentation> origGlobalProfiles) {
        if (proposedGlobalProfiles == null || proposedGlobalProfiles.isEmpty()) {
            return false;
        }
        return !proposedGlobalProfiles.equals(origGlobalProfiles);
    }

    private static boolean isGlobalPoliciesUpdated(List<ClientPolicyRepresentation> proposedGlobalPolicies, List<ClientPolicyRepresentation> origGlobalPolicies) {
        if (proposedGlobalPolicies == null || proposedGlobalPolicies.isEmpty()) {
            return false;
        }
        return !proposedGlobalPolicies.equals(origGlobalPolicies);
    }

    private static boolean isValidExecutor(KeycloakSession session, ClientPolicyExecutorRepresentation executorRep) {
        String executorProviderId = executorRep.getExecutorProviderId();
        Set providerSet = session.listProviderIds(ClientPolicyExecutorProvider.class);
        if (providerSet != null && providerSet.contains(executorProviderId)) {
            if (Objects.nonNull(session.getContext().getRealm())) {
                ClientPolicyExecutorProvider provider = ClientPoliciesUtil.getExecutorProvider(session, session.getContext().getRealm(), executorProviderId, executorRep.getConfiguration());
                ClientPolicyExecutorConfigurationRepresentation configuration = (ClientPolicyExecutorConfigurationRepresentation)JsonSerialization.mapper.convertValue((Object)executorRep.getConfiguration(), provider.getExecutorConfigurationClass());
                return configuration.validateConfig();
            }
            return true;
        }
        logger.warnv("no executor provider found. providerId = {0}", (Object)executorProviderId);
        return false;
    }

    static ClientPoliciesRepresentation getClientPoliciesRepresentation(KeycloakSession session, RealmModel realm) throws ClientPolicyException {
        String policiesJson = ClientPoliciesUtil.getClientPoliciesJsonString(realm);
        if (policiesJson == null) {
            return new ClientPoliciesRepresentation();
        }
        return ClientPoliciesUtil.convertClientPoliciesJsonToRepresentation(policiesJson);
    }

    static List<ClientProfileRepresentation> getGlobalClientProfiles(KeycloakSession session) {
        SecurityProfileProvider securityProfile = (SecurityProfileProvider)session.getProvider(SecurityProfileProvider.class);
        return securityProfile.getDefaultClientProfiles();
    }

    static List<ClientPolicyRepresentation> getGlobalClientPolicies(KeycloakSession session) {
        SecurityProfileProvider securityProfile = (SecurityProfileProvider)session.getProvider(SecurityProfileProvider.class);
        return securityProfile.getDefaultClientPolicies();
    }

    static List<ClientPolicy> getEnabledClientPolicies(KeycloakSession session, RealmModel realm) {
        ArrayList<ClientPolicyRepresentation> policiesRep = new ArrayList<ClientPolicyRepresentation>(ClientPoliciesUtil.getGlobalClientPolicies(session));
        String policiesJson = ClientPoliciesUtil.getClientPoliciesJsonString(realm);
        if (policiesJson != null) {
            try {
                policiesRep.addAll(ClientPoliciesUtil.convertClientPoliciesJsonToRepresentation(policiesJson).getPolicies());
            }
            catch (ClientPolicyException e) {
                logger.warnv("Failed to serialize client policies json string. err={0}, errDetail={1}", (Object)e.getError(), (Object)e.getErrorDetail());
                return Collections.emptyList();
            }
        }
        if (policiesRep.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ClientPolicy> policyList = new ArrayList<ClientPolicy>();
        for (ClientPolicyRepresentation policyRep : policiesRep) {
            if (policyRep.getName() == null) {
                logger.warnf("Ignored client policy without name in the realm %s", (Object)realm.getName());
                continue;
            }
            if (policyRep.isEnabled() == null || !policyRep.isEnabled().booleanValue()) continue;
            ClientPolicy policyModel = new ClientPolicy();
            policyModel.setName(policyRep.getName());
            policyModel.setDescription(policyRep.getDescription());
            policyModel.setEnable(true);
            ArrayList<ClientPolicyConditionProvider> conditions = new ArrayList<ClientPolicyConditionProvider>();
            if (policyRep.getConditions() != null) {
                for (ClientPolicyConditionRepresentation conditionRep : policyRep.getConditions()) {
                    ClientPolicyConditionProvider provider = ClientPoliciesUtil.getConditionProvider(session, realm, conditionRep.getConditionProviderId(), conditionRep.getConfiguration());
                    conditions.add(provider);
                }
            }
            policyModel.setConditions(conditions);
            if (policyRep.getProfiles() != null) {
                policyModel.setProfiles(policyRep.getProfiles().stream().collect(Collectors.toList()));
            }
            policyList.add(policyModel);
        }
        return policyList;
    }

    private static ClientPolicyConditionProvider getConditionProvider(KeycloakSession session, RealmModel realm, String providerId, JsonNode config) {
        JsonConfigComponentModel componentModel = new JsonConfigComponentModel(ClientPolicyConditionProvider.class, realm.getId(), providerId, config);
        ClientPolicyConditionProvider conditionProvider = (ClientPolicyConditionProvider)session.getComponentProvider(ClientPolicyConditionProvider.class, componentModel.getId(), arg_0 -> ClientPoliciesUtil.lambda$getConditionProvider$5((ComponentModel)componentModel, arg_0));
        if (conditionProvider == null) {
            throw new IllegalStateException("Condition with provider ID " + providerId + " not found");
        }
        ClientPolicyConditionConfigurationRepresentation configuration = (ClientPolicyConditionConfigurationRepresentation)JsonSerialization.mapper.convertValue((Object)config, conditionProvider.getConditionConfigurationClass());
        conditionProvider.setupConfiguration(configuration);
        return conditionProvider;
    }

    public static String convertClientPoliciesRepresentationToJson(ClientPoliciesRepresentation reps) throws ClientPolicyException {
        try {
            return JsonSerialization.writeValueAsString((Object)reps);
        }
        catch (IOException ioe) {
            throw new ClientPolicyException(ioe.getMessage());
        }
    }

    private static ClientPoliciesRepresentation convertClientPoliciesJsonToRepresentation(String json) throws ClientPolicyException {
        try {
            return (ClientPoliciesRepresentation)JsonSerialization.readValue((String)json, ClientPoliciesRepresentation.class);
        }
        catch (IOException ioe) {
            throw new ClientPolicyException(ioe.getMessage());
        }
    }

    private static List<ClientPolicyRepresentation> validatePolicies(KeycloakSession session, List<ClientPolicyRepresentation> proposedPoliciesRepList, List<ClientProfileRepresentation> profiles, List<ClientPolicyRepresentation> globalPolicies) throws ClientPolicyException {
        if (proposedPoliciesRepList == null || proposedPoliciesRepList.isEmpty()) {
            return Collections.emptyList();
        }
        if ((long)proposedPoliciesRepList.size() != proposedPoliciesRepList.stream().map(i -> i.getName()).distinct().count()) {
            throw new ClientPolicyException("proposed client policy name duplicated");
        }
        Set globalPolicyNames = globalPolicies.stream().map(ClientPolicyRepresentation::getName).collect(Collectors.toSet());
        for (ClientPolicyRepresentation clientPolicy : proposedPoliciesRepList) {
            if (!globalPolicyNames.contains(clientPolicy.getName())) continue;
            throw new ClientPolicyException("Proposed policy name '" + clientPolicy.getName() + "' is duplicated as a global policy");
        }
        LinkedList<ClientPolicyRepresentation> updatingPolicyList = new LinkedList<ClientPolicyRepresentation>();
        Set profileNames = profiles.stream().map(ClientProfileRepresentation::getName).collect(Collectors.toSet());
        for (ClientPolicyRepresentation proposedPolicyRep : proposedPoliciesRepList) {
            if (proposedPolicyRep.getName() == null) {
                throw new ClientPolicyException("client policy without name not allowed");
            }
            ClientPolicyRepresentation policyRep = new ClientPolicyRepresentation();
            policyRep.setName(proposedPolicyRep.getName());
            policyRep.setDescription(proposedPolicyRep.getDescription());
            policyRep.setEnabled(proposedPolicyRep.isEnabled() != null ? proposedPolicyRep.isEnabled() : Boolean.FALSE);
            policyRep.setConditions(new ArrayList());
            if (proposedPolicyRep.getConditions() != null) {
                for (ClientPolicyConditionRepresentation condition : proposedPolicyRep.getConditions()) {
                    if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.CLIENT_POLICIES) && !ClientPoliciesUtil.isValidCondition(session, condition.getConditionProviderId())) {
                        throw new ClientPolicyException("Policy " + proposedPolicyRep.getName() + " contains invalid condition " + condition.getConditionProviderId());
                    }
                    policyRep.getConditions().add(condition);
                }
            }
            policyRep.setProfiles(new ArrayList());
            if (proposedPolicyRep.getProfiles() != null) {
                if ((long)proposedPolicyRep.getProfiles().size() != proposedPolicyRep.getProfiles().stream().distinct().count()) {
                    throw new ClientPolicyException("Policy " + proposedPolicyRep.getName() + " contains duplicated profiles");
                }
                for (String profile : proposedPolicyRep.getProfiles()) {
                    if (!profileNames.contains(profile)) {
                        throw new ClientPolicyException("Policy " + proposedPolicyRep.getName() + " contains invalid profile " + profile);
                    }
                    policyRep.getProfiles().add(profile);
                }
            }
            updatingPolicyList.add(policyRep);
        }
        return updatingPolicyList;
    }

    static ClientPoliciesRepresentation getValidatedClientPoliciesForUpdate(KeycloakSession session, RealmModel realm, ClientPoliciesRepresentation proposedPoliciesRep, List<ClientProfileRepresentation> existingGlobalProfiles, List<ClientPolicyRepresentation> existingGlobalPolicies) throws ClientPolicyException {
        if (realm == null) {
            throw new ClientPolicyException("realm not specified.");
        }
        if (ClientPoliciesUtil.isGlobalPoliciesUpdated(proposedPoliciesRep.getGlobalPolicies(), existingGlobalPolicies)) {
            throw new ClientPolicyException("Global policies cannot be updated");
        }
        ClientPoliciesRepresentation updatingPoliciesRep = new ClientPoliciesRepresentation();
        ArrayList<ClientProfileRepresentation> allProfiles = new ArrayList<ClientProfileRepresentation>(ClientPoliciesUtil.getClientProfilesRepresentation(session, realm).getProfiles());
        allProfiles.addAll(existingGlobalProfiles);
        updatingPoliciesRep.setPolicies(ClientPoliciesUtil.validatePolicies(session, proposedPoliciesRep.getPolicies(), allProfiles, existingGlobalPolicies));
        return updatingPoliciesRep;
    }

    private static boolean isValidCondition(KeycloakSession session, String conditionProviderId) {
        Set providerSet = session.listProviderIds(ClientPolicyConditionProvider.class);
        if (providerSet != null && providerSet.contains(conditionProviderId)) {
            return true;
        }
        logger.warnv("no condition provider found. providerId = {0}", (Object)conditionProviderId);
        return false;
    }

    static String getClientProfilesJsonString(RealmModel realm) {
        return realm.getAttribute("client-policies.profiles");
    }

    static String getClientPoliciesJsonString(RealmModel realm) {
        return realm.getAttribute("client-policies.policies");
    }

    static void setClientProfilesJsonString(RealmModel realm, String json) {
        realm.setAttribute("client-policies.profiles", json);
    }

    static void setClientPoliciesJsonString(RealmModel realm, String json) {
        realm.setAttribute("client-policies.policies", json);
    }

    private static /* synthetic */ ComponentModel lambda$getConditionProvider$5(ComponentModel componentModel, KeycloakSessionFactory sessionFactory) {
        return componentModel;
    }

    private static /* synthetic */ ComponentModel lambda$getExecutorProvider$1(ComponentModel componentModel, KeycloakSessionFactory sessionFactory) {
        return componentModel;
    }
}

