/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.common.util.UriUtils;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.services.Urls;
import org.keycloak.services.util.ResolveRelative;

public class RedirectUtils {
    public static final Set<String> LOOPBACK_INTERFACES = new HashSet<String>(Arrays.asList("localhost", "127.0.0.1", "[::1]"));
    private static final Logger logger = Logger.getLogger(RedirectUtils.class);
    private static final Pattern UNSAFE_PATH_PATTERN = Pattern.compile("(/|%2[fF]|%5[cC]|\\\\)(%2[eE]|\\.){2}(/|%2[fF]|%5[cC]|\\\\)|(/|%2[fF]|%5[cC]|\\\\)(%2[eE]|\\.){2}$");

    @Deprecated
    public static String verifyRealmRedirectUri(KeycloakSession session, String redirectUri) {
        Set<String> validRedirects = RedirectUtils.getValidateRedirectUris(session);
        return RedirectUtils.verifyRedirectUri(session, null, redirectUri, validRedirects, true);
    }

    public static String verifyRedirectUri(KeycloakSession session, String redirectUri, ClientModel client) {
        return RedirectUtils.verifyRedirectUri(session, redirectUri, client, true);
    }

    public static String verifyRedirectUri(KeycloakSession session, String redirectUri, ClientModel client, boolean requireRedirectUri) {
        if (client != null) {
            return RedirectUtils.verifyRedirectUri(session, client.getRootUrl(), redirectUri, client.getRedirectUris(), requireRedirectUri);
        }
        return null;
    }

    public static Set<String> resolveValidRedirects(KeycloakSession session, String rootUrl, Set<String> validRedirects) {
        TreeSet<String> resolveValidRedirects = new TreeSet<String>((s1, s2) -> s1.length() == s2.length() ? s1.compareTo((String)s2) : (s1.length() < s2.length() ? 1 : -1));
        for (String validRedirect : validRedirects) {
            if (validRedirect.startsWith("/")) {
                validRedirect = RedirectUtils.relativeToAbsoluteURI(session, rootUrl, validRedirect);
                logger.debugv("replacing relative valid redirect with: {0}", (Object)validRedirect);
            }
            resolveValidRedirects.add(validRedirect);
        }
        return resolveValidRedirects;
    }

    @Deprecated
    private static Set<String> getValidateRedirectUris(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        return session.clients().getAllRedirectUrisOfEnabledClients(realm).entrySet().stream().filter(me -> ((ClientModel)me.getKey()).isEnabled() && "openid-connect".equals(((ClientModel)me.getKey()).getProtocol()) && !((ClientModel)me.getKey()).isBearerOnly() && (((ClientModel)me.getKey()).isStandardFlowEnabled() || ((ClientModel)me.getKey()).isImplicitFlowEnabled())).map(me -> RedirectUtils.resolveValidRedirects(session, ((ClientModel)me.getKey()).getRootUrl(), (Set)me.getValue())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static String verifyRedirectUri(KeycloakSession session, String rootUrl, String redirectUri, Set<String> validRedirects, boolean requireRedirectUri) {
        KeycloakUriInfo uriInfo = session.getContext().getUri();
        RealmModel realm = session.getContext().getRealm();
        if (redirectUri == null) {
            if (!requireRedirectUri) {
                redirectUri = RedirectUtils.getSingleValidRedirectUri(validRedirects);
            }
            if (redirectUri == null) {
                logger.debug((Object)"No Redirect URI parameter specified");
                return null;
            }
        } else if (validRedirects.isEmpty()) {
            logger.debug((Object)"No Redirect URIs supplied");
            redirectUri = null;
        } else {
            URI originalRedirect = RedirectUtils.toUri((String)redirectUri);
            if (originalRedirect == null) {
                return null;
            }
            boolean allowWildcards = RedirectUtils.areWildcardsAllowed(originalRedirect);
            String r = redirectUri;
            Set<String> resolveValidRedirects = RedirectUtils.resolveValidRedirects(session, rootUrl, validRedirects);
            String valid = RedirectUtils.matchesRedirects(resolveValidRedirects, r, allowWildcards);
            if (valid == null && "http".equals(originalRedirect.getScheme()) && LOOPBACK_INTERFACES.contains(originalRedirect.getHost())) {
                String redirectWithDefaultPort = KeycloakUriBuilder.fromUri((URI)originalRedirect).port(80).buildAsString(new Object[0]);
                valid = RedirectUtils.matchesRedirects(resolveValidRedirects, redirectWithDefaultPort, allowWildcards);
            }
            if (valid != null && !originalRedirect.isAbsolute()) {
                if (!((String)redirectUri).startsWith("/")) {
                    redirectUri = "/" + (String)redirectUri;
                }
                redirectUri = RedirectUtils.relativeToAbsoluteURI(session, rootUrl, (String)redirectUri);
            }
            String scheme = originalRedirect.getScheme();
            if (!(valid == null || scheme == null || valid.startsWith(scheme + ":") || "http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme))) {
                logger.debugf("Invalid URI because scheme is not allowed: %s", redirectUri);
                valid = null;
            }
            Object object = redirectUri = valid != null ? redirectUri : null;
        }
        if ("urn:ietf:wg:oauth:2.0:oob".equals(redirectUri)) {
            return Urls.realmInstalledAppUrnCallback(uriInfo.getBaseUri(), realm.getName()).toString();
        }
        return redirectUri;
    }

    private static URI toUri(String redirectUri) {
        URI uri = null;
        if (redirectUri != null) {
            try {
                uri = URI.create(redirectUri);
            }
            catch (IllegalArgumentException cause) {
                logger.debugf((Throwable)cause, "Invalid redirect uri %s", (Object)redirectUri);
            }
            catch (Exception cause) {
                logger.debugf((Throwable)cause, "Unexpected error when parsing redirect uri %s", (Object)redirectUri);
            }
        }
        return uri;
    }

    private static boolean areWildcardsAllowed(URI redirectUri) {
        return redirectUri.getRawUserInfo() == null && (redirectUri.getRawPath() == null || !UNSAFE_PATH_PATTERN.matcher(redirectUri.getRawPath()).find());
    }

    private static String relativeToAbsoluteURI(KeycloakSession session, String rootUrl, String relative) {
        if (rootUrl != null) {
            rootUrl = ResolveRelative.resolveRootUrl(session, rootUrl);
        }
        if (rootUrl == null || rootUrl.isEmpty()) {
            rootUrl = UriUtils.getOrigin((URI)session.getContext().getUri().getBaseUri());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(rootUrl);
        sb.append(relative);
        return sb.toString();
    }

    private static String matchesRedirects(Set<String> validRedirects, String redirect, boolean allowWildcards) {
        logger.tracef("matchesRedirects: redirect URL to check: %s, allow wildcards: %b, Configured valid redirect URLs: %s", (Object)redirect, (Object)allowWildcards, validRedirects);
        for (String validRedirect : validRedirects) {
            if ("*".equals(validRedirect)) {
                return validRedirect;
            }
            if (validRedirect.endsWith("*") && !validRedirect.contains("?") && allowWildcards) {
                int length;
                String r;
                int idx = redirect.indexOf(63);
                if (idx == -1) {
                    idx = redirect.indexOf(35);
                }
                if ((r = idx == -1 ? redirect : redirect.substring(0, idx)).startsWith(validRedirect = validRedirect.substring(0, length = validRedirect.length() - 1))) {
                    return validRedirect;
                }
                if (length - 1 > 0 && validRedirect.charAt(length - 1) == '/') {
                    --length;
                }
                if (!(validRedirect = validRedirect.substring(0, length)).equals(r)) continue;
                return validRedirect;
            }
            if (!validRedirect.equals(redirect)) continue;
            return validRedirect;
        }
        return null;
    }

    private static String getSingleValidRedirectUri(Collection<String> validRedirects) {
        if (validRedirects.size() != 1) {
            return null;
        }
        String validRedirect = validRedirects.iterator().next();
        return RedirectUtils.validateRedirectUriWildcard(validRedirect);
    }

    public static String validateRedirectUriWildcard(String redirectUri) {
        if (redirectUri == null) {
            return null;
        }
        int idx = redirectUri.indexOf("/*");
        if (idx > -1) {
            redirectUri = redirectUri.substring(0, idx);
        }
        return redirectUri;
    }
}

