/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.signing;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.jboss.logging.Logger;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.TimeProvider;
import org.keycloak.protocol.oid4vc.issuance.signing.JwtSigningService;
import org.keycloak.protocol.oid4vc.issuance.signing.SigningService;
import org.keycloak.protocol.oid4vc.issuance.signing.SigningServiceException;
import org.keycloak.protocol.oid4vc.model.CredentialSubject;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.sdjwt.DisclosureSpec;
import org.keycloak.sdjwt.SdJwt;
import org.keycloak.sdjwt.SdJwtUtils;

public class SdJwtSigningService
extends SigningService<String> {
    private static final Logger LOGGER = Logger.getLogger(SdJwtSigningService.class);
    private static final String ISSUER_CLAIM = "iss";
    private static final String NOT_BEFORE_CLAIM = "nbf";
    private static final String VERIFIABLE_CREDENTIAL_TYPE_CLAIM = "vct";
    private static final String CREDENTIAL_ID_CLAIM = "jti";
    private final ObjectMapper objectMapper;
    private final SignatureSignerContext signatureSignerContext;
    private final TimeProvider timeProvider;
    private final String tokenType;
    private final String hashAlgorithm;
    private final int decoys;
    private final List<String> visibleClaims;
    protected final String issuerDid;

    public SdJwtSigningService(KeycloakSession keycloakSession, ObjectMapper objectMapper, String keyId, String algorithmType, String tokenType, String hashAlgorithm, String issuerDid, int decoys, List<String> visibleClaims, TimeProvider timeProvider, Optional<String> kid) {
        super(keycloakSession, keyId, algorithmType);
        this.objectMapper = objectMapper;
        this.issuerDid = issuerDid;
        this.timeProvider = timeProvider;
        this.tokenType = tokenType;
        this.hashAlgorithm = hashAlgorithm;
        this.decoys = decoys;
        this.visibleClaims = visibleClaims;
        KeyWrapper signingKey = this.getKey(keyId, algorithmType);
        if (signingKey == null) {
            throw new SigningServiceException(String.format("No key for id %s and algorithm %s available.", keyId, algorithmType));
        }
        if (kid.isPresent()) {
            signingKey = signingKey.cloneKey();
            signingKey.setKid(keyId);
        }
        kid.ifPresent(arg_0 -> ((KeyWrapper)signingKey).setKid(arg_0));
        SignatureProvider signatureProvider = (SignatureProvider)keycloakSession.getProvider(SignatureProvider.class, algorithmType);
        this.signatureSignerContext = signatureProvider.signer(signingKey);
        LOGGER.debugf("Successfully initiated the SD-JWT Signing Service with algorithm %s.", (Object)algorithmType);
    }

    @Override
    public String signCredential(VerifiableCredential verifiableCredential) {
        DisclosureSpec.Builder disclosureSpecBuilder = DisclosureSpec.builder();
        CredentialSubject credentialSubject = verifiableCredential.getCredentialSubject();
        JsonNode claimSet = this.objectMapper.valueToTree((Object)credentialSubject);
        credentialSubject.getClaims().entrySet().stream().filter(entry -> !this.visibleClaims.contains(entry.getKey())).forEach(entry -> {
            if (entry instanceof List) {
                List listValue = (List)((Object)entry);
                IntStream.range(0, listValue.size()).forEach(i -> disclosureSpecBuilder.withUndisclosedArrayElt((String)entry.getKey(), Integer.valueOf(i), SdJwtUtils.randomSalt()));
            } else {
                disclosureSpecBuilder.withUndisclosedClaim((String)entry.getKey(), SdJwtUtils.randomSalt());
            }
        });
        if (this.decoys != 0) {
            IntStream.range(0, this.decoys).forEach(i -> disclosureSpecBuilder.withDecoyClaim(SdJwtUtils.randomSalt()));
        }
        ObjectNode rootNode = claimSet.withObject("");
        rootNode.put(ISSUER_CLAIM, this.issuerDid);
        long iat = Optional.ofNullable(verifiableCredential.getIssuanceDate()).map(issuanceDate -> issuanceDate.toInstant().getEpochSecond()).orElse(Long.valueOf(this.timeProvider.currentTimeSeconds()));
        rootNode.put(NOT_BEFORE_CLAIM, iat);
        if (verifiableCredential.getType() == null || verifiableCredential.getType().size() != 1) {
            throw new SigningServiceException("SD-JWT only supports single type credentials.");
        }
        rootNode.put(VERIFIABLE_CREDENTIAL_TYPE_CLAIM, verifiableCredential.getType().get(0));
        rootNode.put(CREDENTIAL_ID_CLAIM, JwtSigningService.createCredentialId(verifiableCredential));
        SdJwt sdJwt = SdJwt.builder().withDisclosureSpec(disclosureSpecBuilder.build()).withClaimSet(claimSet).withSigner(this.signatureSignerContext).withHashAlgorithm(this.hashAlgorithm).withJwsType(this.tokenType).build();
        return sdJwt.toSdJwtString();
    }
}

