/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import com.webauthn4j.WebAuthnRegistrationManager;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.RegistrationData;
import com.webauthn4j.data.RegistrationParameters;
import com.webauthn4j.data.RegistrationRequest;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.client.challenge.DefaultChallenge;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.exception.WebAuthnException;
import com.webauthn4j.validator.attestation.statement.androidkey.AndroidKeyAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.androidsafetynet.AndroidSafetyNetAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.none.NoneAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.packed.PackedAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.tpm.TPMAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.u2f.FIDOU2FAttestationStatementValidator;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.CertPathTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.DefaultSelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.SelfAttestationTrustworthinessValidator;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.authentication.CredentialRegistrator;
import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.common.util.UriUtils;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.WebAuthnCredentialModelInput;
import org.keycloak.credential.WebAuthnCredentialProvider;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.models.WebAuthnPolicy;
import org.keycloak.models.credential.WebAuthnCredentialModel;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.utils.StringUtil;

public class WebAuthnRegister
implements RequiredActionProvider,
CredentialRegistrator {
    private static final String WEB_AUTHN_TITLE_ATTR = "webAuthnTitle";
    private static final Logger logger = Logger.getLogger(WebAuthnRegister.class);
    private KeycloakSession session;
    private CertPathTrustworthinessValidator certPathtrustValidator;

    public WebAuthnRegister(KeycloakSession session, CertPathTrustworthinessValidator certPathtrustValidator) {
        this.session = session;
        this.certPathtrustValidator = certPathtrustValidator;
    }

    public InitiatedActionSupport initiatedActionSupport() {
        return InitiatedActionSupport.SUPPORTED;
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        UserModel userModel = context.getUser();
        String userId = Base64Url.encode((byte[])userModel.getId().getBytes(StandardCharsets.UTF_8));
        String username = userModel.getUsername();
        DefaultChallenge challenge = new DefaultChallenge();
        String challengeValue = Base64Url.encode((byte[])challenge.getValue());
        context.getAuthenticationSession().setAuthNote("WEBAUTH_CHALLENGE", challengeValue);
        WebAuthnPolicy policy = this.getWebAuthnPolicy(context);
        List signatureAlgorithmsList = policy.getSignatureAlgorithm();
        List<Long> signatureAlgorithms = this.convertSignatureAlgorithms(signatureAlgorithmsList);
        String rpEntityName = policy.getRpEntityName();
        String rpId = policy.getRpId();
        if (rpId == null || rpId.isEmpty()) {
            rpId = context.getUriInfo().getBaseUri().getHost();
        }
        String attestationConveyancePreference = policy.getAttestationConveyancePreference();
        String authenticatorAttachment = policy.getAuthenticatorAttachment();
        String requireResidentKey = policy.getRequireResidentKey();
        String userVerificationRequirement = policy.getUserVerificationRequirement();
        long createTimeout = policy.getCreateTimeout();
        boolean avoidSameAuthenticatorRegister = policy.isAvoidSameAuthenticatorRegister();
        String excludeCredentialIds = "";
        if (avoidSameAuthenticatorRegister) {
            excludeCredentialIds = userModel.credentialManager().getStoredCredentialsByTypeStream(this.getCredentialType()).map(credentialModel -> {
                WebAuthnCredentialModel credModel = WebAuthnCredentialModel.createFromCredentialModel((CredentialModel)credentialModel);
                return Base64Url.encodeBase64ToBase64Url((String)credModel.getWebAuthnCredentialData().getCredentialId());
            }).collect(Collectors.joining(","));
        }
        String isSetRetry = null;
        if (this.isFormDataRequest(context.getHttpRequest())) {
            isSetRetry = (String)context.getHttpRequest().getDecodedFormParameters().getFirst((Object)"isSetRetry");
        }
        Response form = context.form().setAttribute("challenge", (Object)challengeValue).setAttribute("userid", (Object)userId).setAttribute("username", (Object)username).setAttribute("rpEntityName", (Object)rpEntityName).setAttribute("signatureAlgorithms", signatureAlgorithms).setAttribute("rpId", (Object)rpId).setAttribute("attestationConveyancePreference", (Object)attestationConveyancePreference).setAttribute("authenticatorAttachment", (Object)authenticatorAttachment).setAttribute("requireResidentKey", (Object)requireResidentKey).setAttribute("userVerificationRequirement", (Object)userVerificationRequirement).setAttribute("createTimeout", (Object)createTimeout).setAttribute("excludeCredentialIds", (Object)excludeCredentialIds).setAttribute("isSetRetry", (Object)isSetRetry).createForm("webauthn-register.ftl");
        context.challenge(form);
    }

    protected WebAuthnPolicy getWebAuthnPolicy(RequiredActionContext context) {
        return context.getRealm().getWebAuthnPolicy();
    }

    public String getCredentialType(KeycloakSession session, AuthenticationSessionModel authenticationSession) {
        return this.getCredentialType();
    }

    protected String getCredentialType() {
        return "webauthn";
    }

    protected String getCredentialProviderId() {
        return "keycloak-webauthn";
    }

    public void processAction(RequiredActionContext context) {
        RegistrationRequest registrationRequest;
        MultivaluedMap params = context.getHttpRequest().getDecodedFormParameters();
        String isSetRetry = (String)params.getFirst((Object)"isSetRetry");
        if (isSetRetry != null && !isSetRetry.isEmpty()) {
            this.requiredActionChallenge(context);
            return;
        }
        context.getEvent().detail("credential_type", this.getCredentialType());
        String errorMsgFromWebAuthnApi = (String)params.getFirst((Object)"error");
        if (errorMsgFromWebAuthnApi != null && !errorMsgFromWebAuthnApi.isEmpty()) {
            this.setErrorResponse(context, "webauthn-error-register-verification", errorMsgFromWebAuthnApi);
            return;
        }
        WebAuthnPolicy policy = this.getWebAuthnPolicy(context);
        String rpId = policy.getRpId();
        if (rpId == null || rpId.isEmpty()) {
            rpId = context.getUriInfo().getBaseUri().getHost();
        }
        String label = (String)params.getFirst((Object)"authenticatorLabel");
        byte[] clientDataJSON = Base64.getUrlDecoder().decode((String)params.getFirst((Object)"clientDataJSON"));
        byte[] attestationObject = Base64.getUrlDecoder().decode((String)params.getFirst((Object)"attestationObject"));
        String publicKeyCredentialId = (String)params.getFirst((Object)"publicKeyCredentialId");
        Origin origin = new Origin(UriUtils.getOrigin((URI)context.getUriInfo().getBaseUri()));
        DefaultChallenge challenge = new DefaultChallenge(context.getAuthenticationSession().getAuthNote("WEBAUTH_CHALLENGE"));
        ServerProperty serverProperty = new ServerProperty(origin, rpId, (Challenge)challenge, null);
        boolean isUserVerificationRequired = policy.getUserVerificationRequirement().equals("required");
        String transportsParam = (String)params.getFirst((Object)"transports");
        if (StringUtil.isNotBlank((String)transportsParam)) {
            HashSet<String> transports = new HashSet<String>(Arrays.asList(transportsParam.split(",")));
            registrationRequest = new RegistrationRequest(attestationObject, clientDataJSON, transports);
        } else {
            registrationRequest = new RegistrationRequest(attestationObject, clientDataJSON);
        }
        RegistrationParameters registrationParameters = new RegistrationParameters(serverProperty, isUserVerificationRequired);
        if ("on".equals(params.getFirst((Object)"logout-sessions"))) {
            AuthenticatorUtil.logoutOtherSessions(context);
        }
        WebAuthnRegistrationManager webAuthnRegistrationManager = this.createWebAuthnRegistrationManager();
        try {
            RegistrationData registrationData = webAuthnRegistrationManager.parse(registrationRequest);
            webAuthnRegistrationManager.validate(registrationData, registrationParameters);
            this.showInfoAfterWebAuthnApiCreate(registrationData);
            this.checkAcceptedAuthenticator(registrationData, policy);
            WebAuthnCredentialModelInput credential = new WebAuthnCredentialModelInput(this.getCredentialType());
            credential.setAttestedCredentialData(registrationData.getAttestationObject().getAuthenticatorData().getAttestedCredentialData());
            credential.setCount(registrationData.getAttestationObject().getAuthenticatorData().getSignCount());
            credential.setAttestationStatementFormat(registrationData.getAttestationObject().getFormat());
            credential.setTransports(registrationData.getTransports());
            WebAuthnCredentialProvider webAuthnCredProvider = (WebAuthnCredentialProvider)this.session.getProvider(CredentialProvider.class, this.getCredentialProviderId());
            WebAuthnCredentialModel newCredentialModel = webAuthnCredProvider.getCredentialModelFromCredentialInput(credential, label);
            webAuthnCredProvider.createCredential(context.getRealm(), context.getUser(), newCredentialModel);
            String aaguid = newCredentialModel.getWebAuthnCredentialData().getAaguid();
            logger.debugv("WebAuthn credential registration success for user {0}. credentialType = {1}, publicKeyCredentialId = {2}, publicKeyCredentialLabel = {3}, publicKeyCredentialAAGUID = {4}", new Object[]{context.getUser().getUsername(), this.getCredentialType(), publicKeyCredentialId, label, aaguid});
            webAuthnCredProvider.dumpCredentialModel(newCredentialModel, credential);
            context.getEvent().detail("public_key_credential_id", publicKeyCredentialId).detail("public_key_credential_label", label).detail("public_key_credential_aaguid", aaguid);
            context.success();
        }
        catch (WebAuthnException wae) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)wae.getMessage(), (Throwable)wae);
            }
            this.setErrorResponse(context, "webauthn-error-registration", wae.getMessage());
            return;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            this.setErrorResponse(context, "webauthn-error-registration", e.getMessage());
            return;
        }
    }

    private WebAuthnRegistrationManager createWebAuthnRegistrationManager() {
        return new WebAuthnRegistrationManager(Arrays.asList(new NoneAttestationStatementValidator(), new PackedAttestationStatementValidator(), new TPMAttestationStatementValidator(), new AndroidKeyAttestationStatementValidator(), new AndroidSafetyNetAttestationStatementValidator(), new FIDOU2FAttestationStatementValidator()), this.certPathtrustValidator, (SelfAttestationTrustworthinessValidator)new DefaultSelfAttestationTrustworthinessValidator(), Collections.emptyList(), new ObjectConverter());
    }

    private List<Long> convertSignatureAlgorithms(List<String> signatureAlgorithmsList) {
        ArrayList<Long> algs = new ArrayList<Long>();
        if (signatureAlgorithmsList == null || signatureAlgorithmsList.isEmpty()) {
            return algs;
        }
        Iterator<String> iterator = signatureAlgorithmsList.iterator();
        while (iterator.hasNext()) {
            String s;
            switch (s = iterator.next()) {
                case "ES256": {
                    algs.add(COSEAlgorithmIdentifier.ES256.getValue());
                    break;
                }
                case "RS256": {
                    algs.add(COSEAlgorithmIdentifier.RS256.getValue());
                    break;
                }
                case "ES384": {
                    algs.add(COSEAlgorithmIdentifier.ES384.getValue());
                    break;
                }
                case "RS384": {
                    algs.add(COSEAlgorithmIdentifier.RS384.getValue());
                    break;
                }
                case "ES512": {
                    algs.add(COSEAlgorithmIdentifier.ES512.getValue());
                    break;
                }
                case "RS512": {
                    algs.add(COSEAlgorithmIdentifier.RS512.getValue());
                    break;
                }
                case "Ed25519": {
                    algs.add(COSEAlgorithmIdentifier.EdDSA.getValue());
                    break;
                }
                case "RS1": {
                    algs.add(COSEAlgorithmIdentifier.RS1.getValue());
                    break;
                }
            }
        }
        return algs;
    }

    private void showInfoAfterWebAuthnApiCreate(RegistrationData response) {
        AttestedCredentialData attestedCredentialData = response.getAttestationObject().getAuthenticatorData().getAttestedCredentialData();
        AttestationStatement attestationStatement = response.getAttestationObject().getAttestationStatement();
        Set transports = response.getTransports();
        logger.debugv("createad key's algorithm = {0}", (Object)String.valueOf(attestedCredentialData.getCOSEKey().getAlgorithm().getValue()));
        logger.debugv("aaguid = {0}", (Object)attestedCredentialData.getAaguid().toString());
        logger.debugv("attestation format = {0}", (Object)attestationStatement.getFormat());
        if (CollectionUtil.isNotEmpty((Collection)transports)) {
            logger.debugv("transports = [{0}]", (Object)transports.stream().map(AuthenticatorTransport::getValue).collect(Collectors.joining(",")));
        }
    }

    private void checkAcceptedAuthenticator(RegistrationData response, WebAuthnPolicy policy) throws Exception {
        String aaguid = response.getAttestationObject().getAuthenticatorData().getAttestedCredentialData().getAaguid().toString();
        List acceptableAaguids = policy.getAcceptableAaguids();
        boolean isAcceptedAuthenticator = false;
        if (acceptableAaguids != null && !acceptableAaguids.isEmpty()) {
            for (String acceptableAaguid : acceptableAaguids) {
                if (!aaguid.equals(acceptableAaguid)) continue;
                isAcceptedAuthenticator = true;
                break;
            }
        } else {
            isAcceptedAuthenticator = true;
        }
        if (!isAcceptedAuthenticator) {
            throw new WebAuthnException("not acceptable aaguid = " + aaguid);
        }
    }

    public void close() {
    }

    public void evaluateTriggers(RequiredActionContext context) {
    }

    private void setErrorResponse(RequiredActionContext context, String errorCase, String errorMessage) {
        Response errorResponse = null;
        switch (errorCase) {
            case "webauthn-error-register-verification": {
                logger.warnv("WebAuthn API .create() response validation failure. {0}", (Object)errorMessage);
                context.getEvent().detail("web_authn_registration_error", errorCase).detail("web_authn_registration_error_detail", errorMessage).error("invalid_user_credentials");
                errorResponse = context.form().setError(errorCase, new Object[]{errorMessage}).setAttribute(WEB_AUTHN_TITLE_ATTR, (Object)"webauthn-registration-title").createWebAuthnErrorPage();
                context.challenge(errorResponse);
                break;
            }
            case "webauthn-error-registration": {
                logger.warn((Object)errorCase);
                context.getEvent().detail("web_authn_registration_error", errorCase).detail("web_authn_registration_error_detail", errorMessage).error("invalid_registration");
                errorResponse = context.form().setError(errorCase, new Object[]{errorMessage}).setAttribute(WEB_AUTHN_TITLE_ATTR, (Object)"webauthn-registration-title").createWebAuthnErrorPage();
                context.challenge(errorResponse);
                break;
            }
        }
    }

    private boolean isFormDataRequest(HttpRequest request) {
        MediaType mediaType = request.getHttpHeaders().getMediaType();
        return mediaType != null && mediaType.isCompatible(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
    }
}

