/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlow;
import org.keycloak.authentication.AuthenticationFlowCallback;
import org.keycloak.authentication.AuthenticationFlowCallbackFactory;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.AuthenticationSelectionOption;
import org.keycloak.authentication.AuthenticationSelectionResolver;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.authentication.CredentialValidator;
import org.keycloak.authentication.FlowStatus;
import org.keycloak.authentication.ForkFlowException;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticator;
import org.keycloak.authentication.authenticators.util.AuthenticatorUtils;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.ServicesLogger;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.utils.StringUtil;

public class DefaultAuthenticationFlow
implements AuthenticationFlow {
    private static final Logger logger = Logger.getLogger(DefaultAuthenticationFlow.class);
    private final List<AuthenticationExecutionModel> executions;
    private final AuthenticationProcessor processor;
    private final AuthenticationFlowModel flow;
    private boolean successful = false;
    private List<AuthenticationFlowException> afeList = new ArrayList<AuthenticationFlowException>();

    public DefaultAuthenticationFlow(AuthenticationProcessor processor, AuthenticationFlowModel flow) {
        this.processor = processor;
        this.flow = flow;
        this.executions = processor.getRealm().getAuthenticationExecutionsStream(flow.getId()).collect(Collectors.toList());
    }

    protected boolean isProcessed(AuthenticationExecutionModel model) {
        return DefaultAuthenticationFlow.isProcessed(this.processor, model);
    }

    protected static boolean isProcessed(AuthenticationProcessor processor, AuthenticationExecutionModel model) {
        if (model.isDisabled()) {
            return true;
        }
        CommonClientSessionModel.ExecutionStatus status = (CommonClientSessionModel.ExecutionStatus)processor.getAuthenticationSession().getExecutionStatus().get(model.getId());
        if (status == null) {
            return false;
        }
        return status == CommonClientSessionModel.ExecutionStatus.SUCCESS || status == CommonClientSessionModel.ExecutionStatus.SKIPPED || status == CommonClientSessionModel.ExecutionStatus.ATTEMPTED || status == CommonClientSessionModel.ExecutionStatus.SETUP_REQUIRED;
    }

    protected Authenticator createAuthenticator(AuthenticatorFactory factory) {
        return (Authenticator)factory.create(this.processor.getSession());
    }

    public Response processAction(String actionExecution) {
        logger.debugv("processAction: {0}", (Object)actionExecution);
        if (actionExecution == null || actionExecution.isEmpty()) {
            throw new AuthenticationFlowException("action is not in current execution", AuthenticationFlowError.INTERNAL_ERROR);
        }
        AuthenticationExecutionModel model = this.processor.getRealm().getAuthenticationExecutionById(actionExecution);
        if (model == null) {
            throw new AuthenticationFlowException("Execution not found", AuthenticationFlowError.INTERNAL_ERROR);
        }
        if ("POST".equals(this.processor.getRequest().getHttpMethod())) {
            MultivaluedMap inputData = this.processor.getRequest().getDecodedFormParameters();
            String authExecId = (String)inputData.getFirst((Object)"authenticationExecution");
            if (inputData.containsKey((Object)"tryAnotherWay")) {
                logger.trace((Object)"User clicked on link 'Try Another Way'");
                List<AuthenticationSelectionOption> selectionOptions = this.createAuthenticationSelectionList(model);
                AuthenticationProcessor.Result result = this.processor.createAuthenticatorContext(model, null, null);
                result.setAuthenticationSelections(selectionOptions);
                return result.form().createSelectAuthenticator();
            }
            if (authExecId != null && !authExecId.isEmpty()) {
                List<AuthenticationSelectionOption> selectionOptions = this.createAuthenticationSelectionList(model);
                selectionOptions.stream().filter(authSelectionOption -> authExecId.equals(authSelectionOption.getAuthExecId())).findFirst().orElseThrow(() -> new AuthenticationFlowException("Requested authentication execution is not allowed", AuthenticationFlowError.INTERNAL_ERROR));
                model = this.processor.getRealm().getAuthenticationExecutionById(authExecId);
                Response response = this.processSingleFlowExecutionModel(model, false);
                if (response == null) {
                    return this.continueAuthenticationAfterSuccessfulAction(model);
                }
                return response;
            }
        }
        if (model.isAuthenticatorFlow()) {
            logger.debug((Object)"execution is flow");
            AuthenticationFlow authenticationFlow = this.processor.createFlowExecution(model.getFlowId(), model);
            Response flowChallenge = authenticationFlow.processAction(actionExecution);
            if (flowChallenge == null) {
                this.checkAndValidateParentFlow(model);
                return this.processFlow();
            }
            this.setExecutionStatus(model, CommonClientSessionModel.ExecutionStatus.CHALLENGED);
            return flowChallenge;
        }
        AuthenticatorFactory factory = this.getAuthenticatorFactory(model);
        Authenticator authenticator = this.createAuthenticator(factory);
        AuthenticationProcessor.Result result = this.processor.createAuthenticatorContext(model, authenticator, this.executions);
        result.setAuthenticationSelections(this.createAuthenticationSelectionList(model));
        if (factory instanceof AuthenticationFlowCallbackFactory) {
            AuthenticatorUtil.setAuthCallbacksFactoryIds(this.processor.getAuthenticationSession(), factory.getId());
        }
        logger.debugv("action: {0}", (Object)model.getAuthenticator());
        authenticator.action((AuthenticationFlowContext)result);
        Response response = this.processResult(result, true);
        if (response == null) {
            return this.continueAuthenticationAfterSuccessfulAction(model);
        }
        return response;
    }

    private Response continueAuthenticationAfterSuccessfulAction(AuthenticationExecutionModel actionExecutionModel) {
        this.processor.getAuthenticationSession().removeAuthNote("current.authentication.execution");
        String firstUnfinishedParentFlowId = this.checkAndValidateParentFlow(actionExecutionModel);
        AuthenticationExecutionModel parentFlowExecution = this.processor.getRealm().getAuthenticationExecutionByFlowId(firstUnfinishedParentFlowId);
        if (parentFlowExecution == null) {
            return this.processFlow();
        }
        Response response = this.processSingleFlowExecutionModel(parentFlowExecution, false);
        if (response == null) {
            return this.continueAuthenticationAfterSuccessfulAction(parentFlowExecution);
        }
        return response;
    }

    private String checkAndValidateParentFlow(AuthenticationExecutionModel model) {
        AuthenticationExecutionModel parentFlowExecutionModel;
        while ((parentFlowExecutionModel = this.processor.getRealm().getAuthenticationExecutionByFlowId(model.getParentFlow())) != null) {
            block6: {
                block5: {
                    LinkedList<AuthenticationExecutionModel> alternativeExecutions;
                    LinkedList<AuthenticationExecutionModel> requiredExecutions;
                    block4: {
                        block3: {
                            requiredExecutions = new LinkedList<AuthenticationExecutionModel>();
                            alternativeExecutions = new LinkedList<AuthenticationExecutionModel>();
                            this.fillListsOfExecutions(this.processor.getRealm().getAuthenticationExecutionsStream(model.getParentFlow()), requiredExecutions, alternativeExecutions);
                            if (model.isRequired()) break block3;
                            if (!model.isConditional()) break block4;
                        }
                        if (requiredExecutions.stream().allMatch(this.processor::isSuccessful)) break block5;
                    }
                    if (!model.isAlternative()) break block6;
                    if (!alternativeExecutions.stream().anyMatch(this.processor::isSuccessful) || !requiredExecutions.isEmpty()) break block6;
                }
                logger.debugf("Flow '%s' successfully finished after children executions success", (Object)this.logExecutionAlias(parentFlowExecutionModel));
                this.setExecutionStatus(parentFlowExecutionModel, CommonClientSessionModel.ExecutionStatus.SUCCESS);
                model = parentFlowExecutionModel;
                continue;
            }
            return model.getParentFlow();
        }
        return model.getParentFlow();
    }

    public Response processFlow() {
        logger.debugf("processFlow: %s", (Object)this.flow.getAlias());
        ArrayList<AuthenticationExecutionModel> requiredList = new ArrayList<AuthenticationExecutionModel>();
        ArrayList<AuthenticationExecutionModel> alternativeList = new ArrayList<AuthenticationExecutionModel>();
        this.fillListsOfExecutions(this.executions.stream(), requiredList, alternativeList);
        boolean requiredElementsSuccessful = true;
        ListIterator requiredIListIterator = requiredList.listIterator();
        while (requiredIListIterator.hasNext()) {
            AuthenticationExecutionModel required = (AuthenticationExecutionModel)requiredIListIterator.next();
            if (required.isConditional() && !this.isProcessed(required) && this.isConditionalSubflowDisabled(required)) {
                requiredIListIterator.remove();
                continue;
            }
            Response response = this.processSingleFlowExecutionModel(required, true);
            requiredElementsSuccessful &= this.processor.isSuccessful(required) || this.isSetupRequired(required);
            if (response != null) {
                return response;
            }
            if (requiredElementsSuccessful) continue;
            break;
        }
        if (requiredList.isEmpty()) {
            if (alternativeList.stream().anyMatch(alternative -> this.processor.isSuccessful((AuthenticationExecutionModel)alternative) || this.isSetupRequired((AuthenticationExecutionModel)alternative))) {
                return this.onFlowExecutionsSuccessful();
            }
            for (AuthenticationExecutionModel alternative2 : alternativeList) {
                try {
                    Response response = this.processSingleFlowExecutionModel(alternative2, true);
                    if (response != null) {
                        return response;
                    }
                    if (!this.processor.isSuccessful(alternative2) && !this.isSetupRequired(alternative2)) continue;
                    return this.onFlowExecutionsSuccessful();
                }
                catch (AuthenticationFlowException afe) {
                    this.afeList.add(afe);
                    this.setExecutionStatus(alternative2, CommonClientSessionModel.ExecutionStatus.ATTEMPTED);
                }
            }
        } else if (requiredElementsSuccessful) {
            return this.onFlowExecutionsSuccessful();
        }
        return null;
    }

    void fillListsOfExecutions(Stream<AuthenticationExecutionModel> executionsToProcess, List<AuthenticationExecutionModel> requiredList, List<AuthenticationExecutionModel> alternativeList) {
        executionsToProcess.filter(((Predicate<AuthenticationExecutionModel>)this::isConditionalAuthenticator).negate()).forEachOrdered(execution -> {
            if (execution.isRequired() || execution.isConditional()) {
                requiredList.add((AuthenticationExecutionModel)execution);
            } else if (execution.isAlternative()) {
                alternativeList.add((AuthenticationExecutionModel)execution);
            }
        });
        if (!requiredList.isEmpty() && !alternativeList.isEmpty()) {
            List alternativeIds = alternativeList.stream().map(AuthenticationExecutionModel::getAuthenticator).collect(Collectors.toList());
            logger.warnf("REQUIRED and ALTERNATIVE elements at same level! Those alternative executions will be ignored: %s", alternativeIds);
            alternativeList.clear();
        }
    }

    boolean isConditionalSubflowDisabled(AuthenticationExecutionModel model) {
        if (model == null || !model.isAuthenticatorFlow() || !model.isConditional()) {
            return false;
        }
        List modelList = this.processor.getRealm().getAuthenticationExecutionsStream(model.getFlowId()).collect(Collectors.toList());
        List conditionalAuthenticatorList = modelList.stream().filter(this::isConditionalAuthenticator).filter(s -> s.isEnabled()).collect(Collectors.toList());
        boolean conditionalSubflowDisabled = conditionalAuthenticatorList.isEmpty() || conditionalAuthenticatorList.stream().anyMatch(m -> this.conditionalNotMatched((AuthenticationExecutionModel)m, modelList));
        logger.tracef("Conditional subflow '%s' is %s", (Object)this.logExecutionAlias(model), (Object)(conditionalSubflowDisabled ? "disabled" : "enabled"));
        return conditionalSubflowDisabled;
    }

    private boolean isConditionalAuthenticator(AuthenticationExecutionModel model) {
        return !model.isAuthenticatorFlow() && model.getAuthenticator() != null && this.createAuthenticator(this.getAuthenticatorFactory(model)) instanceof ConditionalAuthenticator;
    }

    private AuthenticatorFactory getAuthenticatorFactory(AuthenticationExecutionModel model) {
        AuthenticatorFactory factory = (AuthenticatorFactory)this.processor.getSession().getKeycloakSessionFactory().getProviderFactory(Authenticator.class, model.getAuthenticator());
        if (factory == null) {
            throw new RuntimeException("Unable to find factory for AuthenticatorFactory: " + model.getAuthenticator() + " did you forget to declare it in a META-INF/services file?");
        }
        return factory;
    }

    private boolean conditionalNotMatched(AuthenticationExecutionModel model, List<AuthenticationExecutionModel> executionList) {
        AuthenticationProcessor.Result context;
        AuthenticatorFactory factory = this.getAuthenticatorFactory(model);
        ConditionalAuthenticator authenticator = (ConditionalAuthenticator)this.createAuthenticator(factory);
        boolean matchCondition = authenticator.matchCondition(context = this.processor.createAuthenticatorContext(model, authenticator, executionList));
        this.setExecutionStatus(model, matchCondition ? CommonClientSessionModel.ExecutionStatus.EVALUATED_TRUE : CommonClientSessionModel.ExecutionStatus.EVALUATED_FALSE);
        return !matchCondition;
    }

    private boolean isSetupRequired(AuthenticationExecutionModel model) {
        return CommonClientSessionModel.ExecutionStatus.SETUP_REQUIRED.equals(this.processor.getAuthenticationSession().getExecutionStatus().get(model.getId()));
    }

    private Response processSingleFlowExecutionModel(AuthenticationExecutionModel model, boolean calledFromFlow) {
        logger.debugf("check execution: '%s', requirement: '%s'", (Object)this.logExecutionAlias(model), (Object)model.getRequirement());
        if (this.isProcessed(model)) {
            logger.debugf("execution '%s' is processed", (Object)this.logExecutionAlias(model));
            return null;
        }
        if (model.isAuthenticatorFlow()) {
            AuthenticationFlow authenticationFlow = this.processor.createFlowExecution(model.getFlowId(), model);
            Response flowChallenge = authenticationFlow.processFlow();
            if (flowChallenge == null) {
                if (authenticationFlow.isSuccessful()) {
                    logger.debugf("Flow '%s' successfully finished", (Object)this.logExecutionAlias(model));
                    this.setExecutionStatus(model, CommonClientSessionModel.ExecutionStatus.SUCCESS);
                } else {
                    logger.debugf("Flow '%s' failed", (Object)this.logExecutionAlias(model));
                    this.setExecutionStatus(model, CommonClientSessionModel.ExecutionStatus.FAILED);
                }
                return null;
            }
            this.setExecutionStatus(model, CommonClientSessionModel.ExecutionStatus.CHALLENGED);
            return flowChallenge;
        }
        AuthenticatorFactory factory = this.getAuthenticatorFactory(model);
        Authenticator authenticator = this.createAuthenticator(factory);
        logger.debugv("authenticator: {0}", (Object)factory.getId());
        UserModel authUser = this.processor.getAuthenticationSession().getAuthenticatedUser();
        List<AuthenticationSelectionOption> selectionOptions = this.createAuthenticationSelectionList(model);
        if (!selectionOptions.isEmpty() && calledFromFlow) {
            List finalSelectionOptions = selectionOptions.stream().filter(aso -> !aso.getAuthenticationExecution().isAuthenticatorFlow() && !this.isProcessed(aso.getAuthenticationExecution())).collect(Collectors.toList());
            if (finalSelectionOptions.isEmpty()) {
                return null;
            }
            model = ((AuthenticationSelectionOption)finalSelectionOptions.get(0)).getAuthenticationExecution();
            factory = (AuthenticatorFactory)this.processor.getSession().getKeycloakSessionFactory().getProviderFactory(Authenticator.class, model.getAuthenticator());
            if (factory == null) {
                throw new RuntimeException("Unable to find factory for AuthenticatorFactory: " + model.getAuthenticator() + " did you forget to declare it in a META-INF/services file?");
            }
            authenticator = this.createAuthenticator(factory);
        }
        AuthenticationProcessor.Result context = this.processor.createAuthenticatorContext(model, authenticator, this.executions);
        context.setAuthenticationSelections(selectionOptions);
        if (authenticator.requiresUser()) {
            if (authUser == null) {
                throw new AuthenticationFlowException("authenticator '" + factory.getId() + "' requires user to be set in the authentication context by previous authenticators, but user is not set yet", AuthenticationFlowError.UNKNOWN_USER);
            }
            if (!authenticator.configuredFor(this.processor.getSession(), this.processor.getRealm(), authUser)) {
                if (factory.isUserSetupAllowed() && model.isRequired() && authenticator.areRequiredActionsEnabled(this.processor.getSession(), this.processor.getRealm())) {
                    logger.debugv("authenticator SETUP_REQUIRED: {0}", (Object)factory.getId());
                    this.setExecutionStatus(model, CommonClientSessionModel.ExecutionStatus.SETUP_REQUIRED);
                    authenticator.setRequiredActions(this.processor.getSession(), this.processor.getRealm(), this.processor.getAuthenticationSession().getAuthenticatedUser());
                    return null;
                }
                throw new AuthenticationFlowException("authenticator: " + factory.getId(), AuthenticationFlowError.CREDENTIAL_SETUP_REQUIRED);
            }
        } else if (authUser != null && !authenticator.configuredFor(this.processor.getSession(), this.processor.getRealm(), authUser) && !factory.isUserSetupAllowed() && authenticator instanceof CredentialValidator) {
            throw new AuthenticationFlowException("authenticator: " + factory.getId(), AuthenticationFlowError.CREDENTIAL_SETUP_REQUIRED);
        }
        logger.debugv("invoke authenticator.authenticate: {0}", (Object)factory.getId());
        authenticator.authenticate((AuthenticationFlowContext)context);
        return this.processResult(context, false);
    }

    private String logExecutionAlias(AuthenticationExecutionModel executionModel) {
        if (executionModel.isAuthenticatorFlow()) {
            AuthenticationFlowModel flowModel;
            if (logger.isDebugEnabled() && (flowModel = this.processor.getRealm().getAuthenticationFlowById(executionModel.getFlowId())) != null) {
                return flowModel.getAlias() + " flow";
            }
            return executionModel.getFlowId() + " flow";
        }
        return executionModel.getAuthenticator();
    }

    private List<AuthenticationSelectionOption> createAuthenticationSelectionList(AuthenticationExecutionModel model) {
        return AuthenticationSelectionResolver.createAuthenticationSelectionList(this.processor, model);
    }

    public Response processResult(AuthenticationProcessor.Result result, boolean isAction) {
        AuthenticationExecutionModel execution = result.getExecution();
        FlowStatus status = result.getStatus();
        switch (status) {
            case SUCCESS: {
                logger.debugv("authenticator SUCCESS: {0}", (Object)execution.getAuthenticator());
                this.setExecutionStatus(execution, CommonClientSessionModel.ExecutionStatus.SUCCESS);
                AuthenticatorUtils.updateCompletedExecutions(this.processor.getAuthenticationSession(), this.processor.getUserSession(), execution.getId());
                return null;
            }
            case FAILED: {
                logger.debugv("authenticator FAILED: {0}", (Object)execution.getAuthenticator());
                this.processor.logFailure();
                this.setExecutionStatus(execution, CommonClientSessionModel.ExecutionStatus.FAILED);
                if (result.getChallenge() != null) {
                    return this.sendChallenge(result, execution);
                }
                throw new AuthenticationFlowException(result.getError(), result.getEventDetails(), result.getUserErrorMessage());
            }
            case FORK: {
                logger.debugv("reset browser login from authenticator: {0}", (Object)execution.getAuthenticator());
                this.processor.getAuthenticationSession().setAuthNote("current.authentication.execution", execution.getId());
                throw new ForkFlowException(result.getSuccessMessage(), result.getErrorMessage());
            }
            case FORCE_CHALLENGE: 
            case CHALLENGE: {
                this.setExecutionStatus(execution, CommonClientSessionModel.ExecutionStatus.CHALLENGED);
                return this.sendChallenge(result, execution);
            }
            case FAILURE_CHALLENGE: {
                logger.debugv("authenticator FAILURE_CHALLENGE: {0}", (Object)execution.getAuthenticator());
                this.processor.logFailure();
                this.setExecutionStatus(execution, CommonClientSessionModel.ExecutionStatus.CHALLENGED);
                return this.sendChallenge(result, execution);
            }
            case ATTEMPTED: {
                logger.debugv("authenticator ATTEMPTED: {0}", (Object)execution.getAuthenticator());
                this.setExecutionStatus(execution, CommonClientSessionModel.ExecutionStatus.ATTEMPTED);
                return null;
            }
            case FLOW_RESET: {
                this.processor.resetFlow();
                return this.processor.authenticate();
            }
        }
        logger.debugv("authenticator INTERNAL_ERROR: {0}", (Object)execution.getAuthenticator());
        ServicesLogger.LOGGER.unknownResultStatus();
        throw new AuthenticationFlowException(AuthenticationFlowError.INTERNAL_ERROR);
    }

    public Response sendChallenge(AuthenticationProcessor.Result result, AuthenticationExecutionModel execution) {
        this.processor.getAuthenticationSession().setAuthNote("current.authentication.execution", execution.getId());
        return result.getChallenge();
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public List<AuthenticationFlowException> getFlowExceptions() {
        return this.afeList;
    }

    private void setExecutionStatus(AuthenticationExecutionModel authExecutionModel, CommonClientSessionModel.ExecutionStatus status) {
        this.processor.getAuthenticationSession().setExecutionStatus(authExecutionModel.getId(), status);
        logger.tracef("Set execution status: Execution: %s, status: %s", (Object)this.logExecutionAlias(authExecutionModel), (Object)status);
        if (authExecutionModel.isAuthenticatorFlow() && status == CommonClientSessionModel.ExecutionStatus.SUCCESS) {
            this.processor.getRealm().getAuthenticationExecutionsStream(authExecutionModel.getFlowId()).forEach(this::checkAuthCallback);
        }
    }

    private void checkAuthCallback(AuthenticationExecutionModel execution) {
        AuthenticatorFactory authFactory;
        CommonClientSessionModel.ExecutionStatus executionStatus = (CommonClientSessionModel.ExecutionStatus)this.processor.getAuthenticationSession().getExecutionStatus().get(execution.getId());
        if ((executionStatus == CommonClientSessionModel.ExecutionStatus.SUCCESS || executionStatus == CommonClientSessionModel.ExecutionStatus.EVALUATED_TRUE) && !execution.isAuthenticatorFlow() && (authFactory = this.getAuthenticatorFactory(execution)) instanceof AuthenticationFlowCallbackFactory) {
            AuthenticationFlowCallback authCallback = (AuthenticationFlowCallback)this.createAuthenticator(authFactory);
            logger.tracef("Will trigger callback '%s' after successful finish of the flow '%s'", (Object)authFactory.getId(), (Object)execution.getParentFlow());
            authCallback.onParentFlowSuccess((AuthenticationFlowContext)this.processor.createAuthenticatorContext(execution, (Authenticator)authCallback, null));
            AuthenticatorUtil.setAuthCallbacksFactoryIds(this.processor.getAuthenticationSession(), authFactory.getId());
        }
    }

    private Response onFlowExecutionsSuccessful() {
        if (this.flow.isTopLevel()) {
            logger.debugf("Authentication successful of the top flow '%s'", (Object)this.flow.getAlias());
            this.executeTopFlowSuccessCallbacks();
        }
        this.successful = true;
        return null;
    }

    private void executeTopFlowSuccessCallbacks() {
        AuthenticationSessionModel authSession = this.processor.getAuthenticationSession();
        Set<String> factoryProviderIDs = AuthenticatorUtil.getAuthCallbacksFactoryIds(authSession);
        factoryProviderIDs.stream().filter(StringUtil::isNotBlank).map(id -> (Authenticator)this.processor.getSession().getProvider(Authenticator.class, id)).filter(Objects::nonNull).filter(AuthenticationFlowCallback.class::isInstance).map(AuthenticationFlowCallback.class::cast).forEach(callback -> callback.onTopFlowSuccess(this.flow));
    }
}

