/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.disasm.impl.utils;

import org.jetbrains.annotations.Nullable;

public class StringDisasmUtils {
    public static String escapeString(String str) {
        int codePoint;
        int len = str.length();
        if (len == 0) {
            return "\"\"";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        for (int offset = 0; offset < len; offset += Character.charCount(codePoint)) {
            codePoint = str.codePointAt(offset);
            StringDisasmUtils.processCharInsideString(codePoint, sb);
        }
        sb.append('\"');
        return sb.toString();
    }

    private static void processCharInsideString(int codePoint, StringBuilder sb) {
        String str = StringDisasmUtils.getSpecialStringForChar(codePoint);
        if (str != null) {
            sb.append(str);
            return;
        }
        if (StringDisasmUtils.isPrintable(codePoint)) {
            sb.appendCodePoint(codePoint);
        } else {
            sb.append("\\u").append(String.format("%04x", codePoint));
        }
    }

    private static boolean isPrintable(int codePoint) {
        if (Character.isISOControl(codePoint)) {
            return false;
        }
        if (Character.isWhitespace(codePoint)) {
            return codePoint == 32;
        }
        switch (Character.getType(codePoint)) {
            case 0: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static String getSpecialStringForChar(int c) {
        switch (c) {
            case 10: {
                return "\\n";
            }
            case 13: {
                return "\\r";
            }
            case 9: {
                return "\\t";
            }
            case 8: {
                return "\\b";
            }
            case 12: {
                return "\\f";
            }
            case 39: {
                return "'";
            }
            case 34: {
                return "\\\"";
            }
            case 92: {
                return "\\\\";
            }
        }
        return null;
    }
}

