/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.gui.treemodel.JNode;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.utils.UiUtils;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nullable;

public abstract class JNodeAction
extends AbstractAction {
    private static final long serialVersionUID = -2600154727884853550L;
    private transient CodeArea codeArea;
    @Nullable
    private transient JNode node;

    public JNodeAction(String name, CodeArea codeArea) {
        super(name);
        this.codeArea = codeArea;
    }

    public abstract void runAction(JNode var1);

    public boolean isActionEnabled(@Nullable JNode node) {
        return node != null;
    }

    public void addKeyBinding(KeyStroke key, String id) {
        UiUtils.addKeyBinding((JComponent)((Object)this.codeArea), key, id, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JNodeAction.this.node = JNodeAction.this.codeArea.getNodeUnderCaret();
                if (JNodeAction.this.isActionEnabled(JNodeAction.this.node)) {
                    JNodeAction.this.runAction(JNodeAction.this.node);
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.runAction(this.node);
    }

    public void changeNode(@Nullable JNode node) {
        this.node = node;
        this.setEnabled(this.isActionEnabled(node));
    }

    public CodeArea getCodeArea() {
        return this.codeArea;
    }

    public void dispose() {
        this.node = null;
        this.codeArea = null;
        for (PropertyChangeListener changeListener : this.getPropertyChangeListeners()) {
            this.removePropertyChangeListener(changeListener);
        }
    }
}

