/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.dependencies.DefaultProjectDependencyConstraint;
import org.gradle.api.internal.artifacts.dependencies.DependencyConstraintInternal;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependencyMetadataConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependencyMetadataFactory;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.component.model.LocalComponentDependencyMetadata;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.util.internal.WrapUtil;

public class DefaultDependencyMetadataFactory
implements DependencyMetadataFactory {
    private final List<DependencyMetadataConverter> dependencyDescriptorFactories;

    public DefaultDependencyMetadataFactory(DependencyMetadataConverter ... dependencyDescriptorFactories) {
        this.dependencyDescriptorFactories = WrapUtil.toList((Object[])dependencyDescriptorFactories);
    }

    @Override
    public LocalOriginDependencyMetadata createDependencyMetadata(ComponentIdentifier componentId, @Nullable String clientConfiguration, @Nullable AttributeContainer attributes, ModuleDependency dependency) {
        DependencyMetadataConverter factoryInternal = this.findFactoryForDependency(dependency);
        return factoryInternal.createDependencyMetadata(componentId, clientConfiguration, attributes, dependency);
    }

    @Override
    public LocalOriginDependencyMetadata createDependencyConstraintMetadata(ComponentIdentifier componentId, String clientConfiguration, AttributeContainer attributes, DependencyConstraint dependencyConstraint) {
        ComponentSelector selector = this.createSelector(dependencyConstraint);
        return new LocalComponentDependencyMetadata(componentId, selector, clientConfiguration, attributes, dependencyConstraint.getAttributes(), null, Collections.emptyList(), Collections.emptyList(), ((DependencyConstraintInternal)dependencyConstraint).isForce(), false, false, true, false, dependencyConstraint.getReason());
    }

    private ComponentSelector createSelector(DependencyConstraint dependencyConstraint) {
        if (dependencyConstraint instanceof DefaultProjectDependencyConstraint) {
            return DefaultProjectComponentSelector.newSelector(((DefaultProjectDependencyConstraint)dependencyConstraint).getProjectDependency().getDependencyProject());
        }
        return DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(this.nullToEmpty(dependencyConstraint.getGroup()), this.nullToEmpty(dependencyConstraint.getName())), dependencyConstraint.getVersionConstraint(), dependencyConstraint.getAttributes(), (Collection<Capability>)ImmutableList.of());
    }

    private DependencyMetadataConverter findFactoryForDependency(ModuleDependency dependency) {
        for (DependencyMetadataConverter dependencyMetadataConverter : this.dependencyDescriptorFactories) {
            if (!dependencyMetadataConverter.canConvert(dependency)) continue;
            return dependencyMetadataConverter;
        }
        throw new InvalidUserDataException("Can't map dependency of type: " + dependency.getClass());
    }

    private String nullToEmpty(@Nullable String input) {
        return input == null ? "" : input;
    }
}

