/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.function.Function;
import org.gradle.internal.execution.history.changes.Change;
import org.gradle.internal.execution.history.changes.ChangeVisitor;
import org.gradle.internal.hash.HashCode;

public class CompareStrategy<C, S> {
    private final Function<C, ? extends Map<String, S>> indexer;
    private final Function<C, ? extends Multimap<String, HashCode>> rootHasher;
    private final ChangeDetector<S> changeDetector;

    public CompareStrategy(Function<C, ? extends Map<String, S>> indexer, Function<C, ? extends Multimap<String, HashCode>> rootHasher, ChangeDetector<S> changeDetector) {
        this.indexer = indexer;
        this.rootHasher = rootHasher;
        this.changeDetector = changeDetector;
    }

    public boolean visitChangesSince(C previous, C current, String propertyTitle, ChangeVisitor visitor) {
        if (Iterables.elementsEqual((Iterable)this.rootHasher.apply(previous).entries(), (Iterable)this.rootHasher.apply(current).entries())) {
            return true;
        }
        return this.changeDetector.visitChangesSince(this.indexer.apply(previous), this.indexer.apply(current), propertyTitle, visitor);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static interface ChangeFactory<S> {
        public Change added(String var1, String var2, S var3);

        public Change removed(String var1, String var2, S var3);

        public Change modified(String var1, String var2, S var3, S var4);
    }

    public static interface ChangeDetector<S> {
        public boolean visitChangesSince(Map<String, S> var1, Map<String, S> var2, String var3, ChangeVisitor var4);
    }
}

