/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swt;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.swt.GlazedListsSWT;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Combo;

public class EventComboViewer
implements ListEventListener {
    private Combo combo = null;
    private TransformedList swtSource = null;
    private ILabelProvider labelProvider = null;

    public EventComboViewer(EventList source, Combo combo) {
        this(source, combo, (ILabelProvider)new LabelProvider());
    }

    public EventComboViewer(EventList source, Combo combo, ILabelProvider labelProvider) {
        this.swtSource = GlazedListsSWT.swtThreadProxyList(source, combo.getDisplay());
        this.combo = combo;
        this.labelProvider = labelProvider;
        for (int i = 0; i < source.size(); ++i) {
            this.addRow(i, source.get(i));
        }
        this.swtSource.addListEventListener(this);
    }

    public Combo getCombo() {
        return this.combo;
    }

    private void addRow(int row, Object value) {
        this.combo.add(this.labelProvider.getText(value), row);
    }

    private void updateRow(int row, Object value) {
        this.combo.setItem(row, this.labelProvider.getText(value));
    }

    private void deleteRow(int row) {
        this.combo.remove(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listChanged(ListEvent listChanges) {
        this.swtSource.getReadWriteLock().readLock().lock();
        try {
            while (listChanges.next()) {
                int changeIndex = listChanges.getIndex();
                int changeType = listChanges.getType();
                if (changeType == 2) {
                    this.addRow(changeIndex, this.swtSource.get(changeIndex));
                    continue;
                }
                if (changeType == 1) {
                    this.updateRow(changeIndex, this.swtSource.get(changeIndex));
                    continue;
                }
                if (changeType != 0) continue;
                this.deleteRow(changeIndex);
            }
        }
        finally {
            this.swtSource.getReadWriteLock().readLock().unlock();
        }
    }

    public void dispose() {
        this.swtSource.dispose();
    }
}

