/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import ca.odell.glazedlists.impl.adt.Barcode;

class IndexSnapshot {
    private final Barcode deletes = new Barcode();
    private final Barcode inserts = new Barcode();

    IndexSnapshot() {
    }

    public void reset(int length) {
        this.deletes.clear();
        this.deletes.addBlack(0, length);
        this.inserts.clear();
        this.inserts.addBlack(0, length);
    }

    public int currentToSnapshot(int currentIndex) {
        if (currentIndex < 0 || currentIndex >= this.currentSize()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.inserts.get(currentIndex) == Barcode.WHITE) {
            return this.snapshotSize() + this.inserts.getWhiteIndex(currentIndex);
        }
        currentIndex = this.inserts.getBlackIndex(currentIndex);
        return this.deletes.getIndex(currentIndex, Barcode.BLACK);
    }

    public int snapshotToCurrent(int snapshotIndex) {
        if (snapshotIndex < 0 || snapshotIndex >= this.inserts.whiteSize() + this.snapshotSize()) {
            throw new IndexOutOfBoundsException();
        }
        if (snapshotIndex >= this.snapshotSize()) {
            return this.inserts.getIndex(snapshotIndex - this.snapshotSize(), Barcode.WHITE);
        }
        if (this.deletes.get(snapshotIndex) == Barcode.WHITE) {
            return -1;
        }
        snapshotIndex = this.deletes.getBlackIndex(snapshotIndex);
        return this.inserts.getIndex(snapshotIndex, Barcode.BLACK);
    }

    public void add(int currentIndex) {
        if (currentIndex < 0 || currentIndex > this.currentSize()) {
            throw new IndexOutOfBoundsException();
        }
        this.inserts.addWhite(currentIndex, 1);
    }

    public int currentSize() {
        return this.inserts.size();
    }

    public int snapshotSize() {
        return this.deletes.size();
    }

    public void remove(int currentIndex) {
        if (currentIndex < 0 || currentIndex >= this.currentSize()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.inserts.get(currentIndex) == Barcode.BLACK) {
            int insertAdjusted = this.inserts.getBlackIndex(currentIndex);
            int deleteAdjusted = this.deletes.getIndex(insertAdjusted, Barcode.BLACK);
            this.deletes.set(deleteAdjusted, Barcode.WHITE, 1);
            this.inserts.remove(currentIndex, 1);
        } else {
            this.inserts.remove(currentIndex, 1);
        }
    }
}

