/*
 * Decompiled with CFR 0.152.
 */
package tr.view.projects.templates;

import au.com.thinkingrock.tr.resource.Icons;
import au.com.trgtd.tr.appl.Constants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.openide.awt.Toolbar;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.Item.Item;
import tr.prefs.gui.GUIPrefs;
import tr.view.ReprocessAction;
import tr.view.Window;
import tr.view.projects.ActionNode;
import tr.view.projects.AddActionAction;
import tr.view.projects.AddProjectAction;
import tr.view.projects.EditorTopComponent;
import tr.view.projects.ProjectNode;
import tr.view.projects.ProjectiseAction;
import tr.view.projects.ToggleShowDoneAction;
import tr.view.projects.templates.TemplatesRootNode;

public final class TemplatesTopComponent
extends Window
implements LookupListener,
ExplorerManager.Provider {
    private static final String PREFERRED_ID = "TemplatesTopComponent";
    private static TemplatesTopComponent instance;
    private final transient ExplorerManager manager = new ExplorerManager();
    private transient boolean initialised;
    private transient Lookup.Result dataResult;
    private transient Lookup.Result itemResult;
    private transient JToolBar toolbar;
    private JScrollPane projectsPane;

    private TemplatesTopComponent() {
        this.setName(this.getText("CTL_TemplatesTopComponent"));
        this.setToolTipText(this.getText("HINT_TemplatesTopComponent"));
        this.setIcon(Icons.ProjectsTemplate.getImage());
        this.initComponents();
        this.initialise();
    }

    private void initialise() {
        Data data;
        if (this.initialised) {
            return;
        }
        this.add(this.getToolbar(), GUIPrefs.getBorderLayoutButtonsPosition());
        if (this.dataResult == null) {
            this.dataResult = DataLookup.instance().lookup(new Lookup.Template(Data.class));
            this.dataResult.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    TemplatesTopComponent.this.initialised = false;
                }
            });
        }
        if ((data = (Data)DataLookup.instance().lookup(Data.class)) == null) {
            return;
        }
        this.manager.setRootContext((Node)new TemplatesRootNode(data.getRootTemplates(), false));
        this.manager.getRootContext().setDisplayName(this.getText("CTL_TemplatesNode"));
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true));
        try {
            this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)map));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.initialised = true;
    }

    private JToolBar getToolbar() {
        SystemAction[] actions = new SystemAction[]{SystemAction.get(AddActionAction.class), null, SystemAction.get(AddProjectAction.class), null, SystemAction.get(ReprocessAction.class), null, SystemAction.get(ProjectiseAction.class), null, SystemAction.get(ToggleShowDoneAction.class)};
        this.toolbar = SystemAction.createToolbarPresenter((SystemAction[])actions);
        this.toolbar.setUI(new Toolbar().getUI());
        this.toolbar.setFloatable(false);
        this.toolbar.setOrientation(GUIPrefs.getToolBarOrientation());
        Dimension buttonSize = Constants.TOOLBAR_BUTTON_SIZE;
        for (Component component : this.toolbar.getComponents()) {
            if (!(component instanceof AbstractButton)) continue;
            component.setPreferredSize(buttonSize);
            component.setMinimumSize(buttonSize);
            component.setMaximumSize(buttonSize);
            component.setSize(buttonSize);
        }
        return this.toolbar;
    }

    public void componentOpened() {
        super.componentOpened();
        this.initialise();
    }

    public void componentActivated() {
        super.componentActivated();
        this.initialise();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TemplatesTopComponent.this.activate();
            }
        });
    }

    private void activate() {
        this.itemResult = this.getLookup().lookup(new Lookup.Template(Item.class));
        this.itemResult.addLookupListener((LookupListener)this);
        this.itemResult.allInstances();
        Node[] selectedNodes = this.manager.getSelectedNodes();
        if (selectedNodes.length == 0) {
            try {
                this.manager.setSelectedNodes(new Node[]{this.manager.getRootContext()});
            }
            catch (Exception ex) {}
        } else if (selectedNodes[0] instanceof ProjectNode) {
            ProjectNode projectNode = (ProjectNode)selectedNodes[0];
            EditorTopComponent.findInstance().view((Node)projectNode);
        } else if (selectedNodes[0] instanceof ActionNode) {
            ActionNode actionNode = (ActionNode)selectedNodes[0];
            EditorTopComponent.findInstance().view((Node)actionNode);
        }
    }

    public void componentDeactivated() {
        super.componentDeactivated();
        if (this.itemResult != null) {
            this.itemResult.removeLookupListener((LookupListener)this);
            this.itemResult = null;
        }
    }

    public void resultChanged(LookupEvent lookupEvent) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Node[] nodes = TemplatesTopComponent.this.manager.getSelectedNodes();
                Node node = nodes.length > 0 ? nodes[0] : null;
                EditorTopComponent.findInstance().view(node);
            }
        });
    }

    private String getText(String key) {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)key);
    }

    public TreeView getTreeView() {
        return (TreeView)this.projectsPane;
    }

    private void initComponents() {
        this.projectsPane = new BeanTreeView();
        this.setLayout(new BorderLayout());
        this.add(this.projectsPane, "Center");
    }

    public static synchronized TemplatesTopComponent getDefault() {
        if (instance == null) {
            instance = new TemplatesTopComponent();
        }
        return instance;
    }

    public static synchronized TemplatesTopComponent findInstance() {
        return TemplatesTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 2;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.projects.template");
    }

    public void takeFocus() {
        this.getTreeView().requestFocusInWindow();
    }
}

